#define MAIN_ENTRY
#include "hmiworks.h"
#include "hmi_options.h"
        
#define TICKS_PER_SECOND 100
#define MS_PER_TICK      (1000 / TICKS_PER_SECOND)
//#define APPLICATION_TITLE "TouchPAD-ICPDAS"

volatile tBoolean g_bFirmwareUpdate = false;
unsigned long g_ulWatchdogTimer = 0;

void SysTickIntHandler(void)
{
    hmi_TimerTrigger();
}

int main(void)
{
    if ( HMI_STARTUP_DELAY )
        hmi_DelayUS( HMI_STARTUP_DELAY * 1000 );  

    HMI_INIT(O_LANDSCAPE);
    
    if ( HMI_WDT_ENABLE )  // Enable Watchdog
    {
       hmi_WdtAutoClear( HMI_WDT_CLEAR );
       hmi_WdtEnable( HMI_WDT_TIMEOUT );
    }

    if ( HMI_STARTUP_BEEP )
        hmi_Beep();

    if ( HMI_TOUCH_BEEP )
       hmi_TurnTouchBeep(1);

    if ( HMI_LCD_AUTO_OFF ) 
    {
       hmi_LCDIdleSetTimeout( HMI_LCD_AUTO_OFF * 1000 );
       hmi_LCDIdleSetBeep(HMI_LCD_OFF_BEEP, HMI_LCD_ON_BEEP);
    }

    _frame0();
}
