MEMORY
{
    FLASH (rx)  : ORIGIN = 0x60000000, LENGTH = 0x00800000
    SRAM  (rwx) : ORIGIN = 0x60800000, LENGTH = 0x00400000
    STACK (rwx) : ORIGIN = 0x20016000, LENGTH = 0x00002000
}


SECTIONS
{
    .text :
    {
        _text = .;
        KEEP(*(.isr_vector))
        *(.text*)
        *(.rodata*)
        _etext = .;
    } > FLASH
    .data : AT(ADDR(.text) + SIZEOF(.text))
    {
        _data = .;
        *(vtable)
        *(.data*)
        *(COMMON)
        *(.bss*)
        _edata = .;
    } > SRAM
    .bss :
    {
        _bss = .;
        _ebss = .;
    } > STACK
}
