using System;
using System.Collections.Generic;
using System.Text;
using System.Threading;
using SharedMemory;
using pac8084WNet;
//       8K Module Demo 01
//This demo shows how to read counter and save it to shared memory, and show on eLogger
//Also, you can read the shared memory changed to clear counter.
//
//eLogger Tags : 
//       1.AI tag(name AI0, address 0, Data Type 16-bit Unsigned Integer)
//       2.DO tag(name DO0, address 0)
//
//eLogger Page component:
//       1.TextBox(Tag name AI0)
//       2.SwitchLED(Tag name DO0)
//
//Hardware: 
//       I8084W on slot 0.
namespace Counter_8084W
{
    class Program
    {
        static void Main(string[] args)
        {
            SharedMemOperator RegOperator = new SharedMemOperator();
            int slot = 0;
            int ch = 0;
            uint counter0 = 0;
            byte[] reset = new byte[] { 0, 0 };

            while (true)
            {
                try
                {
                    //Read counter of channel 0, slot 0, I-8084W.
                    pac8084W.ReadFreq(slot, ch, ref counter0);
                    //Save value to shared memory address 0 of AI type.
                    RegOperator.WriteOneInt16Reg(_RegType.tAI, 0, (short)counter0);
                    //Read shared memory address 0 of DO type.
                    RegOperator.ReadBits(_RegType.tDO, 0, 2, reset);

                    if (reset[0] != 0)
                    {
                        //Clear counter
                        pac8084W.ClrCnt(slot, ch);
                        //Set DO address value back to 0
                        RegOperator.WriteOneBit(_RegType.tDO, 0, 0);
                    }
                    Thread.Sleep(200);
                }
                catch (Exception e)
                {
                    Console.WriteLine(e.Message);
                    Console.ReadLine();
                }
            }
        }
    }
}
