using System;
using System.Collections.Generic;
using System.Text;
using System.Threading;
using SharedMemory;
//       8K Module Demo
//This demo shows how to read AI value from shared memory.
//And set DO on when AI value over normal range.
//
//eLogger Tags : 
//       1.AI tag(name AI0, address 0, Data Type 16-bit Signed Integer)
//       2.DO tag(name DO0, address 0)
//
//eLogger Page component:
//       1.TextBox(Tag name AI0)
//       2.SwitchLED(Tag name DO0, MouseControl Disable)
//
//eLogger Hardware Setting: 
//       Driver=>Slot=>I-87019W on slot 0. 
//       Driver=>Slot=>I-87054W on slot 1.
namespace Alarm
{
    class Program   
    {
        static void Main(string[] args)
        {
            SharedMemOperator RegOperator = new SharedMemOperator();
            short[] register = new short[] { 0, 0, 0, 0, 0, 0, 0, 0 };
            byte[] coil = new byte[] { 0, 0, 0, 0, 0, 0, 0, 0 };
            while (true)
            {
                //Read shared memory address 0~7, which record the I-87019's values.
                RegOperator.ReadInt16Regs(_RegType.tAI, 0, 8, register);
                RegOperator.ReadBits(_RegType.tDO, 0, 8, coil);
                //If the channel 0's value is over 0x2000, and the DO is off then set DO on 
                if ((register[0] > 0x2000) && (coil[0] == 0))
                    RegOperator.WriteOneBit(_RegType.tDO, 0, 1); //Set DO on
                else
                    RegOperator.WriteOneBit(_RegType.tDO, 0, 0); //Set DO off
                Thread.Sleep(1000);
            }
        }
    }
}
