/* Example of CAN Device Net Libraryfor PISO-CAN200/400-D/T

   Author: Golden Wang

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */

/* File level history (record changes for this file here.)

   v 0.0.0 20 Dec 2009 by Golden Wang
     create, blah blah... */

#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <sys/ioctl.h>
#include <unistd.h>
#include <string.h>
#include "pisodnm.h"

#define kbhit()   (int)getchar()
char Kbhit(void);
void StrToHex(unsigned char *DataBuf, unsigned char *Str);

char Kbhit(void)
{
  int n=0;

  ioctl(0,FIONREAD,&n);
  if(n) return kbhit();

  return n;
}

void StrToHex(unsigned char *DataBuf, unsigned char *Str)
{
	int j = 0;
	char *tmpval;
	char *lpStop = NULL;

	tmpval = strtok(Str, " ");

        while(tmpval != NULL)
        {
                //printf("val : %s\n", tmpval);
                *(DataBuf) = strtol(tmpval, &lpStop, 16);
                tmpval = strtok(NULL, " ");
                DataBuf++;
        }
}


int main(void)
{
	int ret;
	int board, port, baud_index, baud, macid, init = 0;
	//cpmconfig_t conf;
	//cpmchannel_t channel;
	char command;
  
	printf("\r\n");
	printf("/**************************************/\r\n");
	printf("/* Driver  Version = %s            */\r\n",DNM_GetDriverVersion());
	printf("/* Device Net Library Version = %s */\r\n",DNM_GetLibraryVersion());
	printf("/**************************************/\r\n");
  

	printf("CAN Card Board Number(1~%d) :", MAX_CARD_SUPPORT);
	scanf("%d",&board);

	printf("CAN Card Port Number(1~4) :");
	scanf("%d",&port);

	printf("CAN MacID(0~63):");
        scanf("%d",&macid);

	getchar();

	ret = DNM_Open(board, port);
 
	if (ret)
	{
		printf("Open CAN device failure, Error Code = %d\r\n",ret);
		return 0;
	}

	//init CAN Port
	ret = DNM_InitPort(board, port);

	ret = DNM_Online(board, port, macid);

	if(ret)
	{
		printf("CAN Card Online error, Error Code = %d\r\n",ret);
		return 0;
	}
	else
	{
		printf("CAN Card Online OK\r\n\n");
	}

	printf("DNM Library Demo Item\r\n"); 
	printf("a. CAN DNM Online:\r\n");     //done
	printf("b. CAN DNM Offline:\r\n");    //done
	printf("c. Add Slave Device:\r\n"); //done
	printf("d. Remove Slave Device:\r\n");//done
	printf("e. Configure Explicit Connection:\r\n");//done
	printf("f. Configure Poll Connection:\r\n");//done
	printf("g. Configure BitStrobe Connection:\r\n");//done
	printf("h. Configure COS Connection:\r\n");//done
	printf("i. Configure Cyclic Connection:\r\n");//done
	printf("j. Start Device:\r\n");//done
	printf("k. Get Slave Attribute:\r\n");//done
	printf("l. Get Slave Product Name:\r\n");//done
	printf("m. Set Slave HeartBeat Interval:\r\n");//done
	printf("n. Write Poll Output Data:\r\n");//done
	printf("o. Read Poll Input Data:\r\n");//done
	printf("p. Read BitStrobe Data:\r\n");//done
	printf("q. Write COS Output Data:\r\n");//done
	printf("r. Read COS Input Data:\r\n");//done
	printf("s. Write Cyclic Output Data:\r\n");//done
	printf("t. Read Cyclic Input Data:\r\n");//done
	printf("u. Show DNM Demo Item:\r\n");//done
	printf("z. Shutdown and exit:\r\n"); //done
    
	while(1)
	{
		command = Kbhit();

		if(command)
		{
			switch(command)
			{

				case 'a':	//CAN DNM Online
				{
				        printf("CAN MacID(0~63):");
				        scanf("%d",&macid);
					getchar();

				        ret = DNM_Online(board, port, macid);

					if(ret == 3 )
                                        {
                                                printf("CAN Card already online\r\n");
                                        }
					else if(ret)
				        {
				                printf("CAN Card Online error, Error Code = %d\r\n",ret);
				                return 0;
				        }
				        else
				        {
						printf("CAN Card Online OK\r\n");
					}
      				}
      				break;

				case 'b':	//CAN DNM Offline
				{
					getchar();
					ret = DNM_Offline(board, port);

                                        if(ret == 13)
                                        {
                                                printf("CAN Card already offline \r\n");
                                        }
                                        else
                                        {
                                                printf("CAN Card Offline OK\r\n");
                                        }
      				}
      				break;

				case 'c':	//Add Slave Device
				{
					int node;
        
					printf("Please input slave node address(0~63):");
					scanf("%d",&node);
					getchar();

					ret = DNM_AddDevice(board, port, node);

				        if(ret)
					{
						printf("Add Slave Device Fail :  Error Code = %d\r\n",ret);
					}
					else
					{
						printf("Add Slave Device OK\r\n");
					}
      				}
				break;

				case 'd':	//Remove Slave Device
				{
					int node;

                                        printf("Please input slave node address(0~63):");
                                        scanf("%d",&node);
                                        getchar();

                                        ret = DNM_RemoveDevice(board, port, node);

                                        if(ret)
                                        {
                                                printf("Remove Slave Device Fail :  Error Code = %d\r\n",ret);
                                        }
                                        else
                                        {
                                                printf("Remove Slave Device OK\r\n");
                                        }
      				}
				break;
				
				case 'e':	//Configure Explicit Connection
				{
					int node;

                                        printf("Please input slave node address(0~63):");
                                        scanf("%d",&node);
                                        getchar();

		                        ret = DNM_ConfigExplicitMsg(board , port, node, 1);

                                        if(ret)
                                        {
                                                printf("Configure Explicit Message Fail :  Error Code = %d\r\n",ret);
                                        }
                                        else
                                        {
                                                printf("Configure Explicit Message OK\r\n");
                                        }
      				}
				break;

				case 'f':       //Configure Poll Connection
                                {

                                        int node;

                                        printf("Please input slave node address(0~63):");
                                        scanf("%d",&node);
                                        getchar();

                                        ret = DNM_ConfigPoll(board , port, node, 1, 1, 2500, 0);

                                        if(ret)
                                        {
                                                printf("Configure Poll Connection Fail : Error Code = %d\r\n",ret);
                                        }
                                        else
                                        {
                                                printf("Configure Poll Connection OK\r\n");
                                        }

                                }
                                break;

				case 'g':       //Configure BitStrobe Connection
                                {

                                        int node;

                                        printf("Please input slave node address(0~63):");
                                        scanf("%d",&node);
                                        getchar();

                                        ret = DNM_ConfigBitStrobe(board, port, node, 1, 2500, 0);

                                        if(ret)
                                        {
                                                printf("Configure BitStrobe Connection Fail : Error Code = %d\r\n",ret);
                                        }
                                        else
                                        {
                                                printf("Configure BitStrobe Connection OK\r\n");
                                        }
                                }
                                break;

				case 'h':       //Configure COS Connection
                                {

                                        int node;

                                        printf("Please input slave node address(0~63):");
                                        scanf("%d",&node);
                                        getchar();

                                        ret = DNM_ConfigCOS(board, port, node, 1, 1, 0, 2500, 0);

                                        if(ret)
                                        {
                                                printf("Configure COS Connection Fail : Error Code = %d\r\n",ret);
                                        }
                                        else
                                        {
                                                printf("Configure COS Connection OK\r\n");
                                        }

                                }
                                break;

				case 'i':       //Configure Cyclic Connection
                                {

                                        int node;

                                        printf("Please input slave node address(0~63):");
                                        scanf("%d",&node);
                                        getchar();

                                        ret = DNM_ConfigCyclic(board, port, node, 1, 1, 0, 2500, 0);
                                        if(ret)
                                        {
                                                printf("Configure Cyclic Connection Fail : Error Code = %d\r\n",ret);
                                        }
                                        else
                                        {
                                                printf("Configure Cyclic Connection OK\r\n");
                                        }

                                }
                                break;
			
				case 'j':       //Start Device
                                {
                                        int node;
					int class = 1, instance = 1, attribute = 7;
                                        BYTE get_value[64];
                                        DWORD length;

                                        printf("Please input slave node address(0~63):");
                                        scanf("%d",&node);
                                        getchar();

                                        ret = DNM_StartDevice(board, port, node);

                                        if(ret)
                                        {
                                                printf("Start Device Fail :  Error Code = %d\r\n",ret);
                                        }
                                        else
                                        {
                                                printf("Start Device OK\r\n");
                                        }
                                }
                                break;

				case 'k':	//Get Slave Attribute
                                {
					int node, class, instance, attribute, index;
                                        BYTE get_value[64];
                                        DWORD length;

                                        printf("Please input slave node address(0~63):");
                                        scanf("%d",&node);

                                        printf("Please input class ID(hex):");
                                        scanf("%x",&class);

                                        printf("Please input instance ID(hex):");
                                        scanf("%x",&instance);

                                        printf("Please input attribute ID(hex):");
                                        scanf("%x",&attribute);

                                        getchar();

					ret = DNM_GetAttribute(board, port, node, class, instance, attribute, get_value, &length);

                                        if(ret)
                                        {
                                                printf("DNM Get Attribute Error Code = %d\r\n",ret);
                                        }
                                        else
                                        {

                                                printf("DNM Get Attribute OK\r\n");

                                                printf("Length : %d\n",length);
						printf("Data : ");
                                                for(index = 0; index < length; index++)
                                                {
                                                        printf("%02x ", get_value[index]);
                                                }
						printf("\r\n");
                                        }
                                }
                                break;

				case 'l':	//Get Slave Product Name
				{
					int node, class, instance, attribute, index;
					BYTE get_value[64];
					DWORD length;

                                        printf("Please input slave node address(0~63):");
                                        scanf("%d",&node);

                                        getchar();

					class = 0x01;
					instance = 0x01;
					attribute = 0x07;
       
					ret = DNM_GetAttribute(board, port, node, class, instance, attribute, get_value, &length);

				        if(ret)
					{
					        printf("DNM Get Attribute Error Code = %d\r\n",ret);
				        }
				        else
					{

						printf("DNM Get Slave Product Name OK\r\n");
						
						printf("Slave Product Name : ");

	                                        for(index = 0; index < length; index++)
        	                                {
                	                                printf("%c ", get_value[index]);
                        	                }
						printf("\r\n");
					}
      				}
				break;

				case 'm':	//Set Slave Heartbeat Interval 
				{
					int node, class, instance, attribute;
					BYTE tmpdata[64] = {0}, data[64] = {0};
                                        DWORD length;

                                        printf("Please input slave node address(0~63):");
                                        scanf("%d",&node);

					class = 0x01;
					instance = 0x01;
					attribute = 0x0a;
					data[0] = 0x01;
					length = 1;

                                        getchar();
/*
					printf("Please input Explicit Attribute Data(hex):");

                                        if( fgets( tmpdata, 10, stdin ) == NULL )
                                        {
                                                ret = DNM_Close(board, port);

                                                if(ret)
                                                {
                                                        printf("ShutdownMaster Error Code = %d\r\n",ret);
                                                }
                                                else
                                                {
                                                        printf("DNM Close OK\r\n");
                                                        return 0;
                                                }
                                        }

                                        StrToHex(data, tmpdata);
*/

                                        ret = DNM_SetAttribute(board, port, node, class, instance, attribute, data, length);

					if(ret)
                                        {
                                                printf("DNM Set Slave Heartbeat Interval Error Code = %d\r\n",ret);
                                        }
                                        else
                                        {
                                                printf("DNM Set Slave Heartbeat Interval OK\r\n");
                                        }
      				}
				break;

				case 'n':       //Write Poll Output Data
                                {
                                        int node;
					int i;
                                        BYTE tmpdata[64] = {0}, data[64] = {0};
                                        DWORD length;

                                        printf("Please input slave node address(0~63):");
                                        scanf("%d",&node);
                                        getchar();

                                        printf("Please input Poll Data(hex):");

					if( fgets( tmpdata, 10, stdin ) == NULL )
					{
						ret = DNM_Close(board, port);

                                        	if(ret)
	                                        {
        	                                        printf("ShutdownMaster Error Code = %d\r\n",ret);
                	                        }
                        	                else
                                	        {
                                        	        printf("DNM Close OK\r\n");
                                                	return 0;
	                                        }
					}

					StrToHex(data, tmpdata);

                                        ret = DNM_WritePollOutputData(board, port, node, data, 1);
                                        if(ret)
                                        {
                                                printf("DNM Write Poll Output Data Error Code = %d\r\n",ret);
                                        }
					else
                                        {
                                                printf("DNM Write Poll Output Data OK\r\n");
                                        }
                                }
                                break;

				case 'o':       //Read Poll Input Data
                                {
					int node;
                                        int i;
                                        BYTE data[64] = {0};
                                        DWORD length;

                                        printf("Please input slave node address(0~63):");
                                        scanf("%d",&node);
                                        getchar();

                                        ret = DNM_ReadPollInputData(board, port, node, data, &length);
                                        if(ret)
                                        {
                                                printf("DNM Read Poll Input Data Error Code = %d\r\n",ret);
                                        }
                                        else
                                        {
                                                printf("DNM Read Poll Input Data OK\r\n");
						
						for(i = 0; i < length; i++)
						{
							printf("Data[%d] : 0x%x ",i,data[i]);

						}
				
						printf("\r\n");
                                        }
                                }
                                break;

				case 'p':       //Read BitStrobe Data
                                {
                                        int node;
                                        int i;
                                        BYTE data[64] = {0};
                                        DWORD length;

                                        printf("Please input slave node address(0~63):");
                                        scanf("%d",&node);
                                        getchar();

                                        ret = DNM_ReadBitStrobe(board, port, node, data, &length);
                                        if(ret)
                                        {
                                                printf("DNM Read BitStrobe Data Error Code = %d\r\n",ret);
                                        }
                                        else
                                        {
                                                printf("DNM Read BitStrobe Data OK\r\n");

                                                for(i = 0; i < length; i++)
                                                {
                                                        printf("Data[%d] : 0x%x ",i,data[i]);

                                                }

                                                printf("\r\n");
                                        }
                                }
				break;	

				case 'q':       //Write COS Output Data
                                {
                                        int node;
                                        int i;
                                        BYTE tmpdata[64] = {0}, data[64] = {0};
                                        DWORD length;

                                        printf("Please input slave node address(0~63):");
                                        scanf("%d",&node);
                                        getchar();

                                        printf("Please input COS Data(hex):");

                                        if( fgets( tmpdata, 10, stdin ) == NULL )
                                        {
                                                ret = DNM_Close(board, port);

                                                if(ret)
                                                {
                                                        printf("ShutdownMaster Error Code = %d\r\n",ret);
                                                }
                                                else
                                                {
                                                        printf("DNM Close OK\r\n");
                                                        return 0;
                                                }
                                        }

					StrToHex(data, tmpdata);

                                        ret = DNM_WriteCOSOutputData(board, port, node, data, 1);

                                        if(ret)
                                        {
                                                printf("DNM Write COS Output Data Error Code = %d\r\n",ret);
                                        }
                                        else
                                        {
                                                printf("DNM Write COS Output Data OK\r\n");
                                        }
                                }
                                break;

                                case 'r':       //Read COS Input Data
                                {
                                        int node;
                                        int i;
                                        BYTE data[64] = {0};
                                        DWORD length;

					printf("Please input slave node address(0~63):");
                                        scanf("%d",&node);
                                        getchar();

                                        ret = DNM_ReadCOSInputData(board, port, node, data, &length);
                                        if(ret)
                                        {
                                                printf("DNM Read COS Input Data Error Code = %d\r\n",ret);
                                        }
                                        else
                                        {
                                                printf("DNM Read COS Input Data OK\r\n");

                                                for(i = 0; i < length; i++)
                                                {
                                                        printf("Data[%d] : 0x%x ",i,data[i]);

                                                }

                                                printf("\r\n");
                                        }
                                }
                                break;

				case 's':       //Write Cyclic Output Data
                                {
                                        int node;
                                        int i;
                                        BYTE tmpdata[64] = {0}, data[64] = {0};
                                        DWORD length;

                                        printf("Please input slave node address(0~63):");
                                        scanf("%d",&node);
                                        getchar();

                                        printf("Please input Cyclic Data(hex):");

                                        if( fgets( tmpdata, 10, stdin ) == NULL )
                                        {
                                                ret = DNM_Close(board, port);

                                                if(ret)
                                                {
                                                        printf("ShutdownMaster Error Code = %d\r\n",ret);
                                                }
                                                else
                                                {
                                                        printf("DNM Close OK\r\n");
                                                        return 0;
                                                }
                                        }

					StrToHex(data, tmpdata);

					ret = DNM_WriteCyclicOutputData(board, port, node, data, 1);

                                        if(ret)
                                        {
                                                printf("DNM Write Cyclic Output Data Error Code = %d\r\n",ret);
                                        }
                                        else
                                        {
                                                printf("DNM Write Cyclic Output Data OK\r\n");
                                        }
                                }
                                break;

                                case 't':       //Read Cyclic Input Data
                                {
                                        int node;
                                        int i;
                                        BYTE data[64] = {0};
                                        DWORD length;

                                        printf("Please input slave node address(0~63):");
                                        scanf("%d",&node);
                                        getchar();

					ret = DNM_ReadCyclicInputData(board, port, node, data, &length);
                                        if(ret)
                                        {
                                                printf("DNM Read Cyclic Input Data Error Code = %d\r\n",ret);
                                        }
                                        else
                                        {
                                                printf("DNM Read Cyclic Input Data OK\r\n");

                                                for(i = 0; i < length; i++)
                                                {
                                                        printf("Data[%d] : 0x%x ",i,data[i]);

                                                }

                                                printf("\r\n");
                                        }
                                }
                                break;

				case 'u':	//Show DNM Demo Item
				{
					getchar();
		
					printf("DNM Library Demo Item\r\n");
				        printf("a. CAN DNM Online:\r\n");     //done
				        printf("b. CAN DNM Offline:\r\n");    //done
				        printf("c. Add Slave Device:\r\n"); //done
				        printf("d. Remove Slave Device:\r\n");//done
				        printf("e. Configure Explicit Connection:\r\n");
				        printf("f. Configure Poll Connection:\r\n");
				        printf("g. Configure BitStrobe Connection:\r\n");
				        printf("h. Configure COS Connection:\r\n");
				        printf("i. Configure Cyclic Connection:\r\n");
				        printf("j. Start Device:\r\n");//done
					printf("k. Get Slave Attribute:\r\n");//done
					printf("l. Get Slave Product Name:\r\n");//done
					printf("m. Set Slave HeartBeat Interval:\r\n");//done
				        printf("n. Write Poll Output Data:\r\n");//done
				        printf("o. Read Poll Input Data:\r\n");//done
				        printf("p. Read BitStrobe Data:\r\n");//done
				        printf("q. Write COS Output Data:\r\n");//done
				        printf("r. Read COS Input Data:\r\n");//done
				        printf("s. Write Cyclic Output Data:\r\n");//done
				        printf("t. Read Cyclic Input Data:\r\n");//done
				        printf("u. Show DNM Demo Item:\r\n");//done
				        printf("z. Shutdown and exit:\r\n"); //done
      				}
				break;  

				case 'z':
				{
					getchar();

					ret = DNM_Offline(board, port);

                                        if(ret == 13)
                                        {
                                                printf("CAN Card already offline \r\n");
                                                //return 0;
                                        }
                                        else
                                        {
                                                printf("CAN Card Offline OK\r\n");
                                        }

					ret = DNM_Close(board, port);
				
					if(ret)
					{
						printf("ShutdownMaster Error Code = %d\r\n",ret);
					}
					else
					{
						printf("DNM Close OK\r\n");
						return 0;
					}
				}
			        break;
				default:
				        printf("Unknow command = %X\r\n",command);
			        break;
			}
		}
	}

	return 0;
}
