//////////////////////////////////////////////////////////////////
//
// CAN200_RtxApp.c - C file
//
// This file was generated using the RTX Application Wizard 
// for Visual Studio.  
//////////////////////////////////////////////////////////////////
    
#include "CAN200_RtxApp.h"
#include  "can.h"


#define TimeOut 10000L

#define P1 1
#define P2 2

BYTE BoardNo;
BYTE BaudRate;

LARGE_INTEGER Start_64,End_64;


void 
_cdecl
wmain(
       int     argc,
       wchar_t **argv,
       wchar_t **envp
     )

{
    //
    // TO DO:  your program code here
    //

	WORD ret;
	WORD Toggle;
	WORD TxRx_Data_Cnt=0;
	WORD Send_Err=0, Send_OK=0,Rece_Err=0, Rece_OK=0;
	WORD MesgCnt,CountDown;
	PacketStruct TxCANMsg, RxCANMsg;

    //
    // TO DO:  your program code here
    //

	RtPrintf("**********PISO-CAN200 Receive Test!**********\n");
	RtPrintf("PISO-CAN200 Board Number 0:\n");
	RtPrintf("BaudRate 1 Mbps:\n");

	BoardNo = 0;
	BaudRate = 8;

	ret = CAN_ActiveBoard(BoardNo);	// Active PISO-CAN200
	if(ret){
		RtPrintf("CAN200_ActiveBoard Error ret = %d \n",ret);
		return;
	}

	ret = CAN_Reset(BoardNo,P1);	// Reset CAN port 1
	if(ret){
		RtPrintf("CAN200_Reset Port 1 Error ret = %d \n",ret);
		CAN_CloseBoard(BoardNo);
		return;
	}

	ret = CAN_Reset(BoardNo,P2);	// Reset CAN port 2
	if(ret){
		RtPrintf("CAN200_Reset Port 2 Error ret = %d \n",ret);
		CAN_CloseBoard(BoardNo);
		return;
	}

	ret = CAN_Init(BoardNo,P1);		// Initialize CAN port 1
	if(ret){
		RtPrintf("CAN200_Init Port 1 Error ret = %d \n",ret);
		CAN_CloseBoard(BoardNo);
		return;
	}

	ret = CAN_Init(BoardNo,P2);		// Initialize CAN port 2
	if(ret){
		RtPrintf("CAN200_Init Port 2 Error ret = %d \n",ret);
		CAN_CloseBoard(BoardNo);
		return;
	}

	// Set port 1 ACC & ACM & Baud
	ret = CAN_ConfigWithoutStruct(BoardNo,P1,0x00000000,0xffffffff,BaudRate,0,0);
	if(ret){
		RtPrintf("CAN200_ConfigWithoutStruct Port 1 Error ret = %d\n",ret);
		CAN_CloseBoard(BoardNo);
		return;
	}

	// Set port 2 ACC & ACM & Baud
	ret = CAN_ConfigWithoutStruct(BoardNo,P2,0x00000000,0xffffffff,BaudRate,0,0);
	if(ret){
		RtPrintf("CAN200_ConfigWithoutStruct Port 2 Error ret = %d\n",ret);
		CAN_CloseBoard(BoardNo);
		return;
	}

	ret = CAN_InstallIrq(BoardNo);	// Install PCI interrupt
	if(ret){
		RtPrintf("CAN_InstallIrq Error ret = %d\n",ret);
		CAN_CloseBoard(BoardNo);
		return;
	}

	ret = CAN_EnableRxIrq(BoardNo, P1);	// Enable CAN port 1 "Receive Interrupt"
	if(ret){
		RtPrintf("CAN_EnableRxIrq Port 1 Error ret = %d\n",ret);
		CAN_CloseBoard(BoardNo);
		return;
	}

	ret = CAN_EnableRxIrq(BoardNo, P2);	// Enable CAN port 2 "Receive Interrupt"
	if(ret){
		RtPrintf("CAN_EnableRxIrq Port 2 Error ret = %d\n",ret);
		CAN_CloseBoard(BoardNo);
		return;
	}

	CountDown = TimeOut;
	Toggle=0;

	TxCANMsg.id=0x12345678UL;
	TxCANMsg.mode=0;
	TxCANMsg.rtr=0;
	TxCANMsg.len=8;
	TxCANMsg.data[0]=1;
	TxCANMsg.data[1]=2;
	TxCANMsg.data[2]=3;
	TxCANMsg.data[3]=4;
	TxCANMsg.data[4]=5;
	TxCANMsg.data[5]=6;
	TxCANMsg.data[6]=7;
	TxCANMsg.data[7]=8;

	RtPrintf("Start to send and receive...\r\n");

	{
		RtPrintf("Test 1000 Msg Cnt:");

		TxRx_Data_Cnt = 1000;

		do{
			if(!Toggle){	// Send
				ret = CAN_SendMsg(BoardNo,P1,&TxCANMsg);
				if(ret){
					Send_Err++;	// Send Error
				}
				else{
					Toggle = 1;	// Change to Receive
					
					if(!Send_OK) RtGetClockTime(CLOCK_2,&Start_64);	// Save the "Start Time" 

					Send_OK++;
					CountDown = TimeOut;
				}
			}
			
			if(Toggle){		// Receive
				MesgCnt = CAN_RxMsgCount(BoardNo,P2);
				if(MesgCnt){	// Check if port 2 had received the CAN message
					ret = CAN_ReceiveMsg(BoardNo, P2, &RxCANMsg);
					if(ret){
						Rece_Err++;	// Receive Error
					}
					else{
						Toggle = 0;	// Change to Send
						Rece_OK++;

						if(Rece_OK == TxRx_Data_Cnt) break; // if the received message achieve 10000, then break

						CountDown = TimeOut;
					}
				}
			}

			Sleep(0);
		}while(CountDown--);

		RtGetClockTime(CLOCK_2,&End_64);	// End the time

		RtPrintf("Send OK: %u , Send Error: %u \n",Send_OK,Send_Err);
		RtPrintf("Rece OK: %u , Rece Error: %u \n",Rece_OK,Rece_Err);
		RtPrintf("Total Time: %lu \n",End_64.QuadPart - Start_64.QuadPart);

		CountDown = TimeOut;

		Send_OK = Send_Err = 0;
		Rece_OK = Rece_Err = 0;
		Toggle=0;

		CAN_CloseBoard(BoardNo);
	}

    ExitProcess(0);
}
