#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <sys/ioctl.h>
#include <unistd.h>
#include <string.h>
#include <signal.h>
#include <pthread.h>
#include <unistd.h>
#include <math.h>
#include "ixpci.h"

/* unmark following line to enable debug message */
//#define DBG

/* debug flags */
#ifdef DBG
#define dbg(fmt, args...) printf(fmt, ##args)
#else
#define dbg(fmt, args...)
#endif

/* defined ERROR ID */
#define CAN_NOERROR 0
#define CAN_OPEN_ERROR 1
#define CAN_CLOSE_ERROR 2
#define CAN_INIT_ERROR 3
#define CAN_CONFIG_ERROR 4
#define CAN_ENABLERXIRQ_ERROR 5
#define CAN_DISABLERXIRQ_ERROR 6
#define CAN_ENABLETXIRQ_ERROR 7
#define CAN_DISABLETXIRQ_ERROR 8
#define CAN_SENDMSG_WITHIRQ_ERROR 9
#define CAN_SENDMSG_WITHOUTIRQ_ERROR 10
#define CAN_RECEIVEMSG_WITHIRQ_ERROR 11
#define CAN_RECEIVEMSG_WITHOUTIRQ_ERROR 12
#define CAN_CLEARDATA_OVERRUN_ERROR 13
#define CAN_IOCTL_COMMAND_ERROR 14

/* define driver and dll version */
//#define IXPCI_DRIVER_VERSION "0.7.5"
#define CAN_LIBARY_VERSION "0.1.0" 
#define CAN_MODULE_NAME
#define LINE_SIZE 128
#define MAX_BOARD_NUMBER 30
#define MAX_CARD_SUPPORT 4
#define MAX_CAN400_PORT 4
#define MAX_CAN200_PORT 2

typedef unsigned short WORD;
typedef unsigned int DWORD;
typedef void (*HANDLE)(int);
typedef unsigned char BYTE;
typedef int BOOL;


#define CAN_OVERRUN_IRQ	CAN_OVERRUN_INT                         
//#define CAN_ERROR_INT                           
#define CAN_TRANSMIT_IRQ CAN_TRANSMIT_INT
#define CAN_RECEIVE_IRQ CAN_RECEIVE_INT


/* implement the function in pisocan.c */

int CAN_Open(char *);
WORD CAN_Close(int);
char * CAN_GetDriverVersion(void);
char * CAN_GetLibraryVersion(void);
WORD CAN_Init(int);
WORD CAN_Config(int, DWORD, DWORD, DWORD);
WORD CAN_EnableRxIrq(int); 
WORD CAN_DisableRxIrq(int); 
WORD CAN_EnableTxIrq(int);
WORD CAN_DisableTxIrq(int);
WORD CAN_SendMsgWithIrq(int, canmsg_t [], DWORD);  
WORD CAN_SendMsgWithoutIrq(int, ixpci_canreg_t *); 
WORD CAN_ReceiveMsgWithIrq(int, canmsg_t [], DWORD);  
WORD CAN_ReceiveMsgWithoutIrq(int, ixpci_canreg_t *); 
WORD CAN_GetStatus(int, CanStatusPar_t *); 
//WORD CAN_GetStatus(int, ixpci_canreg_t *); 
WORD CAN_RxIrqStatus(int); 
WORD CAN_IrqStatus(int); 
WORD CAN_ClearDataOverrun(int);
WORD CAN_RxMsgCount(int);

