/* Declarations for PCI DAQ series.

   Author: Reed Lai

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */

/* File level history (record changes for this file here.)

   v 0.14.0 1 Apr 2011 by Golden Wang
     Give support to linux kernel 2.6.37.

   v 0.13.0 12 May 2010 by Golden Wang
     To add driver for Lanner OEM I/O Card.

   v 0.12.0 16 Aug 2009 by Golden Wang
     To add driver, library for PISO-CAN200/400 Series Cards.

   v 0.11.1 16 May 2007 by Golden Wang
     Don't include "linux/cdev.h" here.

   v 0.11.0 6 Feb 2007 by Golden Wang
     Give support to linux kernel 2.6.X

   v 0.10.0 25 Jun 2003 by Reed Lai
     Defines IXPCI_PROC_FILE.

   v 0.9.0 11 Mar 2003 by Reed Lai
     Gives support to PCI-TMC12.
     Gives sub-vendor and sub-device IDs.

   v 0.8.0  9 Jan 2003 by Reed Lai
     PCI-1002.

   v 0.7.0  9 Jan 2003 by Reed Lai
     Gives support to PCI-P8R8.

   v 0.6.0  7 Jan 2003 by Reed Lai
     Gives support to PCI-1002.
     Adds base address ranges for ixpci_devinfo.

   v 0.5.0 11 Nov 2002 by Reed Lai
     ICPDAS_LICENSE
     Removes some unused symbols.

   v 0.4.2 11 Sep 2002 by Reed Lai
     Adds symbol void *(_cardname) (int,int)

   v 0.4.1 26 Jul 2002 by Reed Lai
     Just refines some codes.

   v 0.4.0 16 May 2002 by Reed Lai
     Gives support to PCI-P16R16/P16C16/P16POR16

   v 0.3.0  1 Nov 2001 by Reed Lai
     Macros for Kernel 2.2 compatibility
	 cleanup_module()
	 init_module()

   v 0.2.0 31 Oct 2001 by Reed Lai
     Macros for Kernel 2.2 compatibility
         module_register_chrdev()
	 module_unregister_chrdev()

   v 0.1.0 25 Oct 2001 by Reed Lai
     Re-filenames to ixpci.h (from pdaq.h.)
     Changes all "pdaq" to "ixpci."

   v 0.0.0 10 Apr 2001 by Reed Lai
     Create.  */
/* *INDENT-OFF* */

#ifndef _IXPCI_H
#define _IXPCI_H

#include <linux/types.h>
#include <linux/pci.h>
#include <linux/version.h>
#include <linux/wait.h>
#include "can.h"
//#include <linux/ioport.h>
//#include <asm/io.h>

#define ICPDAS_LICENSE "GPL"

/* General Definition */
#ifndef SUCCESS
#define SUCCESS 0
#endif

#ifndef FAILURE
#define FAILURE -1
#endif

#ifndef SA_SHIRQ
#define SA_SHIRQ IRQF_SHARED
#endif

#define IXPCI_DRIVER_VERSION "0.8.2"
#define ORGANIZATION "icpdas"
#define FAMILY "ixpci"			/* name of family */
#define DEVICE_NAME "ixpci"		/* device name used in /dev and /proc */
#define DEVICE_NAME_LEN 5
#define DEVICE_NR_DEVS 4
#define DEVICE_MAJOR 0			/* dynamic allocation of major number */
#define DEVICE_MINOR 0			

#if LINUX_VERSION_CODE >= KERNEL_VERSION(2,2,0)
#define IXPCI_PROC_FILE "/proc/ixpci/ixpci"
#else
#define IXPCI_PROC_FILE "/proc/ixpci"
#endif

#define PCI_BASE_ADDRESSES_NUMBER  6
#define PBAN  PCI_BASE_ADDRESSES_NUMBER

#define CARD_NAME_LENGTH  32
#define CNL  CARD_NAME_LENGTH

#define KMSG(fmt, args...) printk(KERN_INFO FAMILY ": " fmt, ## args)

/* PCI Card's ID (vendor id).(device id) */
/*
          0x 1234 5678 1234 5678
             ---- ---- ---- ----
              |    |     |    |
      vendor id    |     |    sub-device id
	       device id     sub-vendor id
*/

#define PCI_1800       0x1234567800000000
#define PCI_1802       0x1234567800000000
#define PCI_1602       0x1234567800000000
#define PCI_1602_A     0x1234567600000000
#define PCI_1202       0x1234567200000000
#define PCI_1002       0x12341002c1a20823
#define PCI_P16C16     0x12341616c1a20823
#define PCI_P16R16     0x12341616c1a20823
#define PCI_P16POR16   0x12341616c1a20823
#define PCI_P8R8       0x12340808c1a20823
#define PCI_TMC12      0x10b5905021299912
#define PCI_M512       0x10b5905021290512
#define PCI_M256       0x10b5905021290256
#define PCI_M128       0x10b5905021290128
#define PCI_9050EVM    0x10b5905010b59050
#define PISO_CAN200    0x10b590502129c200
#define PISO_CAN400    0x10b590502129c400
#define PISO_CAN200U   0x10b590302129c210
#define PISO_CAN400U   0x10b590302129c410
#define PISO_CAN200E   0x10b590502129c280
#define PISO_CAN400E   0x10b590502129c480
#define PCM_CAN200     0x10b590302129c250
#define PCM_CAN400     0x10b590302129c450
#define PCI_LANNER     0x1415951114150000
/*
#define PCI_1800      0x1234567800000000	
#define PCI_1802      0x1234567800000000	
#define PCI_1602      0x1234567800000000	
#define PCI_1602_A    0x1234567600000000	
#define PCI_1202      0x1234567200000000
#define PCI_1002      0x12341002c1a20823
#define PCI_P16C16    0x12341616c1a20823	
#define PCI_P16R16    0x12341616c1a20823	
#define PCI_P16POR16  0x12341616c1a20823	
#define PCI_P8R8      0x12340808c1a20823
#define PCI_TMC12     0x10b5905021299912
#define PCI_M512      0x10b5905021290512
#define PCI_M256      0x10b5905021290256
#define PCI_M128      0x10b5905021290128
#define PCI_9050EVM   0x10b5905010b59050
*/

#define IXPCI_VENDOR(a)		((a) >> 48)
#define IXPCI_DEVICE(a)		(((a) >> 32) & 0x0ffff)
#define IXPCI_SUBVENDOR(a)	(((a) >> 16) & 0x0ffff)
#define IXPCI_SUBDEVICE(a)	((a) & 0x0ffff)

/* The chaos of name convention from hardware manual... */
enum {
	IXPCI_8254_COUNTER_0,
	IXPCI_8254_COUNTER_1,
	IXPCI_8254_COUNTER_2,
	IXPCI_8254_CONTROL_REG,
	IXPCI_SELECT_THE_ACTIVE_8254_CHIP,
	IXPCI_GENERAL_CONTROL_REG,
	IXPCI_STATUS_REG,
	IXPCI_AD_SOFTWARE_TRIGGER_REG,
	IXPCI_DIGITAL_INPUT_PORT,
	IXPCI_DIGITAL_OUTPUT_PORT,
	IXPCI_ANALOG_INPUT_CHANNEL_CONTROL_REG,
	IXPCI_ANALOG_INPUT_GAIN_CONTROL_REG,
	IXPCI_ANALOG_INPUT_PORT,
	IXPCI_ANALOG_OUTPUT_CHANNEL_1,
	IXPCI_ANALOG_OUTPUT_CHANNEL_2,
	IXPCI_PCI_INTERRUPT_CONTROL_REG,
	IXPCI_CLEAR_INTERRUPT,
	IXPCI_LAST_REG,
	IXPCI_SRAM_512,
	IXPCI_BATTERY_VOLTAGE_STATUS,
	IXPCI_AD_GAIN_CONTROL_AND_MULTIPLEXER_CONTROL_REGISTER,
	IXPCI_AD_POLLING_REGISTER,
	IXPCI_EEPROM_REGISTER,
	IXPCI_READ_COUNTER0,
	IXPCI_CLEAR_COUNTER0,
	IXPCI_READ_COUNTER1,
	IXPCI_CLEAR_COUNTER1,

	/* defined for CAN Card */
	IXPCI_CANSTATUS_REG,
	IXPCI_CAN_COMMAND_CONFIG,
	IXPCI_CAN_COMMAND_STARTCHIP,
	IXPCI_CAN_COMMAND_STOPCHIP,
	IXPCI_CAN_COMMAND_INITCHIP,
	IXPCI_CAN_COMMAND_CLEARBUFFERS,
	IXPCI_CAN_SEND_MESSAGE,
	IXPCI_CAN_RECEIVE_MESSAGE,
	IXPCI_CAN_ENABLE_TXIRQ,
        IXPCI_CAN_DISABLE_TXIRQ,
	IXPCI_CAN_ENABLE_RXIRQ,
	IXPCI_CAN_DISABLE_RXIRQ,
	IXPCI_CAN_RXIRQ_STATUS,
	IXPCI_CAN_IRQ_STATUS,
	IXPCI_CAN_CLEAR_OVERRUN,
	IXPCI_CAN_RXMSG_COUNT
};

#define IXPCI_8254C0       IXPCI_8254_COUNTER_0
#define IXPCI_8254C1       IXPCI_8254_COUNTER_1
#define IXPCI_8254C2       IXPCI_8254_COUNTER_2
#define IXPCI_8254CR       IXPCI_8254_CONTROL_REG
#define IXPCI_8254_CHIP_SELECT IXPCI_SELECT_THE_ACTIVE_8254_CHIP
#define IXPCI_8254CS       IXPCI_8254_CHIP_SELECT
#define IXPCI_GCR          IXPCI_GENERAL_CONTROL_REG
#define IXPCI_CONTROL_REG  IXPCI_GENERAL_CONTROL_REG
#define IXPCI_CR           IXPCI_CONTROL_REG
#define IXPCI_SR           IXPCI_STATUS_REG
#define IXPCI_ADST         IXPCI_AD_SOFTWARE_TRIGGER_REG
#define IXPCI_DI           IXPCI_DIGITAL_INPUT_PORT
#define IXPCI_DO           IXPCI_DIGITAL_OUTPUT_PORT
#define IXPCI_AICR         IXPCI_ANALOG_INPUT_CHANNEL_CONTROL_REG
#define IXPCI_AIGR         IXPCI_ANALOG_INPUT_GAIN_CONTROL_REG
#define IXPCI_AI           IXPCI_ANALOG_INPUT_PORT
#define IXPCI_AD           IXPCI_AI
#define IXPCI_AO1          IXPCI_ANALOG_OUTPUT_CHANNEL_1
#define IXPCI_DA1          IXPCI_AO1
#define IXPCI_AO2          IXPCI_ANALOG_OUTPUT_CHANNEL_2
#define IXPCI_DA2          IXPCI_AO2
#define IXPCI_PICR         IXPCI_PCI_INTERRUPT_CONTROL_REG
#define IXPCI_CI           IXPCI_CLEAR_INTERRUPT
#define IXPCI_SRAM512      IXPCI_SRAM_512
#define IXPCI_BATTERY_STATUS IXPCI_BATTERY_VOLTAGE_STATUS
#define IXPCI_ADGCR	   IXPCI_AD_GAIN_CONTROL_AND_MULTIPLEXER_CONTROL_REGISTER	
#define IXPCI_ADPR	   IXPCI_AD_POLLING_REGISTER	
#define IXPCI_EEP	   IXPCI_EEPROM_REGISTER	
#define IXPCI_READ_C0	   IXPCI_READ_COUNTER0	
#define IXPCI_CLEAR_C0	   IXPCI_CLEAR_COUNTER0	
#define IXPCI_READ_C1	   IXPCI_READ_COUNTER1	
#define IXPCI_CLEAR_C1	   IXPCI_CLEAR_COUNTER1	
#define IXPCI_CAN_STATUS   IXPCI_CANSTATUS_REG
#define IXPCI_CAN_CONFIG IXPCI_CAN_COMMAND_CONFIG 
#define IXPCI_CAN_STARTCHIP IXPCI_CAN_COMMAND_STARTCHIP
#define IXPCI_CAN_STOPCHIP IXPCI_CAN_COMMAND_STOPCHIP
#define IXPCI_CAN_INITCHIP IXPCI_CAN_COMMAND_INITCHIP
#define IXPCI_CAN_CLEARBUFFERS IXPCI_CAN_COMMAND_CLEARBUFFERS
#define IXPCI_CAN_SENDMSG IXPCI_CAN_SEND_MESSAGE
#define IXPCI_CAN_RECEMSG IXPCI_CAN_RECEIVE_MESSAGE
#define IXPCI_CAN_ENABLETXIRQ IXPCI_CAN_ENABLE_TXIRQ
#define IXPCI_CAN_RXMSGCOUNT IXPCI_CAN_RXMSG_COUNT
#define IXPCI_CAN_DISABLETXIRQ IXPCI_CAN_DISABLE_TXIRQ
#define IXPCI_CAN_ENABLERXIRQ IXPCI_CAN_ENABLE_RXIRQ
#define IXPCI_CAN_DISABLERXIRQ IXPCI_CAN_DISABLE_RXIRQ
#define IXPCI_CAN_RXIRQSTATUS IXPCI_CAN_RXIRQ_STATUS
#define IXPCI_CAN_IRQSTATUS IXPCI_CAN_IRQ_STATUS
#define IXPCI_CAN_CLEAROVERRUN IXPCI_CAN_CLEAR_OVERRUN

/* IXPCI structure for signal conditions */
typedef struct ixpci_signal {
	int sid;					/* signal id */
	pid_t pid;					/* process id */
	struct task_struct *task;	/* pointer to task structure */
	int is;						/* mask for irq source 0 disable 1 enable */
	int edge;					/* active edge for each irq source 0 for
								   negative (falling) edge 1 for positive
								   (rising) edge */
	int bedge;					/* both edges, or bipolar. 0 up to the
								   setting in variable edge. 1 does action 
								   for both negative and positive
								   edges, discards setting in variable
								   edge.  */
} ixpci_signal_t;

/* IXPCI structure for register */
typedef struct ixpci_reg {
	unsigned int id;			/* register's id */
	unsigned int value;			/* register's value for read/write */
	unsigned int sram_off;			/* sram offset for sram card */
	int mode;
} ixpci_reg_t;

/* IXPCI structure for CAN register */
typedef struct ixpci_canreg {
        unsigned int id;                        /* ioctl command id */
	unsigned int value;
        /* config value for CAN */
	CanStatusPar_t stat;
        canmsg_t tx;
        canmsg_t rx;
        unsigned int baud;
//        unsigned char ocr;
        unsigned int acr;
        unsigned int amr;                                       /* operation mode */
} ixpci_canreg_t;




//typedef struct canmsg {
    /** flags, indicating or controlling special message properties */
//    int             flags;
//    int             cob;         /**< CAN object number, used in Full CAN  */
//    unsigned   long id;          /**< CAN message ID, 4 bytes  */
//    struct timeval  timestamp;   /**< time stamp for received messages */
//    short      int  length;      /**< number of bytes in the CAN message */
//    unsigned   char data[CAN_MSG_LENGTH]; /**< data, 0...8 bytes */
//} canmsg_t;

//typedef struct cnafifo {
//        int head;
//        int tail;
//        int status;
//        int active;
//        char free[MAX_BUFSIZE];
//        canmsg_t data[MAX_BUFSIZE];
//} canfifo_t;



/* register operation mode */
enum {
	IXPCI_RM_RAW,				/* read/write directly without data mask */
	IXPCI_RM_NORMAL,			/* read/write directly */
	IXPCI_RM_READY,				/* blocks before ready */
	IXPCI_RM_TRIGGER,			/* do software trigger before ready (blocked) */
	IXPCI_RM_LAST_MODE
};

/* IXPCI cards' definition */
struct ixpci_carddef {
	__u64 id;						/* composed sub-ids */
	unsigned int present;		/* card's present counter */
	char *module;				/* module name, if card is present then
								   load module in this name */
	char *name;					/* card's name */
};

extern struct ixpci_carddef ixpci_card[];

/* IXPCI device information for found cards' list */
typedef struct ixpci_devinfo {
	struct ixpci_devinfo *next;	/* next device (ixpci card) */
	struct ixpci_devinfo *prev;	/* previous device */
	struct ixpci_devinfo *next_f;	/* next device in same family */
	struct ixpci_devinfo *prev_f;	/* previous device in same family */
	unsigned int cno;			/* card number */
	unsigned int no;			/* device number (minor number) */
	__u64 id;		/* card's id */
	unsigned int irq;			/* interrupt */
	unsigned long base[PBAN];	/* base I/O addresses */
	unsigned int range[PBAN];	/* ranges for each I/O address */
	void *ioaddr[PBAN];	/* mmio address */
	unsigned int open;			/* open counter */
#if LINUX_VERSION_CODE >= KERNEL_VERSION(2,6,0)
        struct cdev *cdev;
#else
        struct file_operations *fops;   /* file operations for this device */
#endif
	char name[CNL];				/* card name information */
	struct ixpci_signal sig;	/* user signaling for interrupt */

	/* add under field for PISO CAN card */
	//wait_queue_head_t canoutwait;
	//spinlock_t write_splock;
	unsigned int canports;		/* total ports in the CAN card */
	unsigned int canportid;		/* port number in the CAN card */
	can_devinfo_t *caninfo;
/*
	canfifo_t tx_buf[MAX_CAN_PORTS];
	canfifo_t rx_buf[MAX_CAN_PORTS];
	unsigned int baud[MAX_CAN_PORTS];
	unsigned int ocr[MAX_CAN_PORTS];
	unsigned int acr[MAX_CAN_PORTS];
	unsigned int amr[MAX_CAN_PORTS];
*/
	
} ixpci_devinfo_t;

/* IOCTL command IDs */
enum {
	IXPCI_IOCTL_ID_RESET,
	IXPCI_IOCTL_ID_GET_INFO,
	IXPCI_IOCTL_ID_SET_SIG,
	IXPCI_IOCTL_ID_READ_REG,
	IXPCI_IOCTL_ID_WRITE_REG,
	IXPCI_IOCTL_ID_TIME_SPAN,
	IXPCI_IOCTL_ID_DI,
	IXPCI_IOCTL_ID_DO,
	IXPCI_IOCTL_ID_IRQ_ENABLE,
	IXPCI_IOCTL_ID_IRQ_DISABLE,
	IXPCI_IOCTL_ID_LAST_ITEM
};
/* IXPCI IOCTL command */
#define IXPCI_MAGIC_NUM  0x26	/* why? ascii codes 'P' + 'D' + 'A' + 'Q' */
#define IXPCI_GET_INFO   _IOR(IXPCI_MAGIC_NUM, IXPCI_IOCTL_ID_GET_INFO, ixpci_devinfo_t *)

#define IXPCI_SET_SIG    _IOR(IXPCI_MAGIC_NUM, IXPCI_IOCTL_ID_SET_SIG, ixpci_signal_t *)

#define IXPCI_READ_REG   _IOR(IXPCI_MAGIC_NUM, IXPCI_IOCTL_ID_READ_REG, ixpci_reg_t *)
#define IXPCI_WRITE_REG  _IOR(IXPCI_MAGIC_NUM, IXPCI_IOCTL_ID_WRITE_REG, ixpci_reg_t *)
#define IXPCI_TIME_SPAN  _IOR(IXPCI_MAGIC_NUM, IXPCI_IOCTL_ID_TIME_SPAN, int)
#define IXPCI_WAIT       IXPCI_TIME_SPAN
#define IXPCI_DELAY      IXPCI_TIME_SPAN
#define IXPCI_BLOCK      IXPCI_TIME_SPAN
#define IXPCI_RESET      _IO(IXPCI_MAGIC_NUM, IXPCI_IOCTL_ID_RESET)

#define IXPCI_IOCTL_DI   _IOR(IXPCI_MAGIC_NUM, IXPCI_IOCTL_ID_DI, void *)
#define IXPCI_IOCTL_DO   _IOR(IXPCI_MAGIC_NUM, IXPCI_IOCTL_ID_DO, void *)

#define IXPCI_IRQ_ENABLE  _IO(IXPCI_MAGIC_NUM, IXPCI_IOCTL_ID_IRQ_ENABLE)
#define IXPCI_IRQ_DISABLE  _IO(IXPCI_MAGIC_NUM, IXPCI_IOCTL_ID_IRQ_DISABLE)

/* Exported Symbols */
#ifdef __KERNEL__

/* from ixpcitmc12.o */

#if LINUX_VERSION_CODE >= KERNEL_VERSION(2,6,36)
long ixpcitmc12_ioctl(struct file *, unsigned int, unsigned long);
#else
int ixpcitmc12_ioctl(struct inode *, struct file *, unsigned int, unsigned long);
#endif

#if LINUX_VERSION_CODE >= KERNEL_VERSION(2,2,0)
int ixpcitmc12_release(struct inode *, struct file *);
#else
void ixpcitmc12_release(struct inode *, struct file *);
#endif
int ixpcitmc12_open(struct inode *, struct file *);

/* from ixpcip16x16.o */
#if LINUX_VERSION_CODE >= KERNEL_VERSION(2,6,36)
long ixpcip16x16_ioctl(struct file *, unsigned int, unsigned long);
#else
int ixpcip16x16_ioctl(struct inode *, struct file *, unsigned int, unsigned long);
#endif

#if LINUX_VERSION_CODE >= KERNEL_VERSION(2,2,0)
int ixpcip16x16_release(struct inode *, struct file *);
#else
void ixpcip16x16_release(struct inode *, struct file *);
#endif
int ixpcip16x16_open(struct inode *, struct file *);

/* from ixpcip8r8.o */
#if LINUX_VERSION_CODE >= KERNEL_VERSION(2,6,36)
long ixpcip8r8_ioctl(struct file *, unsigned int, unsigned long);
#else
int ixpcip8r8_ioctl(struct inode *, struct file *, unsigned int, unsigned long);
#endif

#if LINUX_VERSION_CODE >= KERNEL_VERSION(2,2,0)
int ixpcip8r8_release(struct inode *, struct file *);
#else
void ixpcip8r8_release(struct inode *, struct file *);
#endif
int ixpcip8r8_open(struct inode *, struct file *);

/* from ixpci1800.o */
#if LINUX_VERSION_CODE >= KERNEL_VERSION(2,6,36)
long ixpci1800_ioctl(struct file *, unsigned int, unsigned long);
#else
int ixpci1800_ioctl(struct inode *, struct file *, unsigned int, unsigned long);
#endif

#if LINUX_VERSION_CODE >= KERNEL_VERSION(2,2,0)
int ixpci1800_release(struct inode *, struct file *);
#else
void ixpci1800_release(struct inode *, struct file *);
#endif
int ixpci1800_open(struct inode *, struct file *);

/* from ixpci1202.o */

#if LINUX_VERSION_CODE >= KERNEL_VERSION(2,6,36)
long ixpci1202_ioctl(struct file *, unsigned int, unsigned long);
#else
int ixpci1202_ioctl(struct inode *, struct file *, unsigned int, unsigned long);
#endif

#if LINUX_VERSION_CODE >= KERNEL_VERSION(2,2,0)
int ixpci1202_release(struct inode *, struct file *);
#else
void ixpci1202_release(struct inode *, struct file *);
#endif
int ixpci1202_open(struct inode *, struct file *);

/* from ixpci1002.o */

#if LINUX_VERSION_CODE >= KERNEL_VERSION(2,6,36)
long ixpci1002_ioctl(struct file *, unsigned int, unsigned long);
#else
int ixpci1002_ioctl(struct inode *, struct file *, unsigned int, unsigned long);
#endif

#if LINUX_VERSION_CODE >= KERNEL_VERSION(2,2,0)
int ixpci1002_release(struct inode *, struct file *);
#else
void ixpci1002_release(struct inode *, struct file *);
#endif
int ixpci1002_open(struct inode *, struct file *);

/* from ixpci1602.o */

#if LINUX_VERSION_CODE >= KERNEL_VERSION(2,6,36)
long ixpci1602_ioctl(struct file *, unsigned int, unsigned long);
#else
int ixpci1602_ioctl(struct inode *, struct file *, unsigned int, unsigned long);
#endif

#if LINUX_VERSION_CODE >= KERNEL_VERSION(2,2,0)
int ixpci1602_release(struct inode *, struct file *);
#else
void ixpci1602_release(struct inode *, struct file *);
#endif
int ixpci1602_open(struct inode *, struct file *);

/* from ixpcim512.o */

#if LINUX_VERSION_CODE >= KERNEL_VERSION(2,6,36)
long ixpcim512_ioctl(struct file *, unsigned int, unsigned long);
#else
int ixpcim512_ioctl(struct inode *, struct file *, unsigned int, unsigned long);
#endif

#if LINUX_VERSION_CODE >= KERNEL_VERSION(2,2,0)
int ixpcim512_release(struct inode *, struct file *);
#else
void ixpcim512_release(struct inode *, struct file *);
#endif
int ixpcim512_open(struct inode *, struct file *);

/* from ixpisocan200.o */

#if LINUX_VERSION_CODE >= KERNEL_VERSION(2,6,36)
long ixpisocan200_ioctl(struct file *, unsigned int, unsigned long);
#else
int ixpisocan200_ioctl(struct inode *, struct file *, unsigned int, unsigned long);
#endif

#if LINUX_VERSION_CODE >= KERNEL_VERSION(2,2,0)
int ixpisocan200_release(struct inode *, struct file *);
#else
void ixpisocan200_release(struct inode *, struct file *);
#endif
int ixpisocan200_open(struct inode *, struct file *);
ssize_t ixpisocan200_read(struct file *file,char *buffer,size_t length,loff_t *offset);
ssize_t ixpisocan200_write(struct file *file, const char *buffer, size_t length, loff_t *offset);

/* from ixpisocan400.o */

#if LINUX_VERSION_CODE >= KERNEL_VERSION(2,6,36)
long ixpisocan400_ioctl(struct file *, unsigned int, unsigned long);
#else
int ixpisocan400_ioctl(struct inode *, struct file *, unsigned int, unsigned long);
#endif

#if LINUX_VERSION_CODE >= KERNEL_VERSION(2,2,0)
int ixpisocan400_release(struct inode *, struct file *);
#else
void ixpisocan400_release(struct inode *, struct file *);
#endif
int ixpisocan400_open(struct inode *, struct file *);
ssize_t ixpisocan400_read(struct file *file,char *buffer,size_t length,loff_t *offset);
ssize_t ixpisocan400_write(struct file *file, const char *buffer, size_t length, loff_t *offset);

/* from ixpcilanner.o */

#if LINUX_VERSION_CODE >= KERNEL_VERSION(2,6,36)
long ixpcilanner_ioctl(struct file *, unsigned int, unsigned long);
#else
int ixpcilanner_ioctl(struct inode *, struct file *, unsigned int, unsigned long);
#endif

#if LINUX_VERSION_CODE >= KERNEL_VERSION(2,2,0)
int ixpcilanner_release(struct inode *, struct file *);
#else
void ixpcilanner_release(struct inode *, struct file *);
#endif
int ixpcilanner_open(struct inode *, struct file *);


/* from ixpci.o */
void *(_cardname) (__u64, int);
void *(_pci_cardname) (__u64);
void (ixpci_copy_devinfo) (ixpci_devinfo_t *, ixpci_devinfo_t *);
extern ixpci_devinfo_t *ixpci_dev;
extern int ixpci_major;
//extern int ixpci_total_boards;

/* from _proc.o */
int ixpci_proc_init(void);
void ixpci_proc_exit(void);

#if LINUX_VERSION_CODE < KERNEL_VERSION(2,4,0)
#define devfs_register_chrdev(a,b,c) module_register_chrdev(a,b,c)
#define devfs_unregister_chrdev(a,b) module_unregister_chrdev(a,b)
#define ixpci_init(a) init_module(a)
#define ixpci_cleanup(a) cleanup_module(a)
#endif

#endif							/* __KERNEL__ */

#endif							/* _IXPCI_H */
/* *INDENT-ON* */
