#include <linux/types.h>
#include <linux/ioctl.h>

#ifndef PACKED
#define PACKED __attribute__((packed))
#endif

#define CAN_TIMEOUT_CNT 50000
#define CAN_MSG_LENGTH 8
#ifndef MAX_BUFSIZE
# define MAX_BUFSIZE 65535
/* #define MAX_BUFSIZE 1000 */
/* #define MAX_BUFSIZE 4 */
#endif

#define BUF_EMPTY    0
#define BUF_OK       1
#define BUF_FULL     BUF_OK
#define BUF_OVERRUN  2
#define BUF_UNDERRUN 3

#define MAX_CAN_PORTS 4

#define CAN_MSG_LENGTH 8                /**< maximum length of a CAN frame */

#define CAN_TYPE_UNSPEC         0
#define CAN_TYPE_SJA1000        1


#define MSG_STD         0               /**< standard message format */
#define MSG_RTR         (1<<0)          /**< RTR Message */
#define MSG_OVR         (1<<1)          /**< CAN controller Msg overflow error */
#define MSG_EXT         (1<<2)          /**< extended message format */
#define MSG_SELF        (1<<3)          /**< message received from own tx */
#define MSG_PASSIVE     (1<<4)          /**< controller in error passive */
#define MSG_BUSOFF      (1<<5)          /**< controller Bus Off  */
#define MSG_            (1<<6)          /**<  */
#define MSG_BOVR        (1<<7)          /**< receive/transmit buffer overflow */
#define MSG_ERR_MASK    (MSG_OVR + MSG_PASSIVE + MSG_BUSOFF + MSG_BOVR)
/*--- Interrupt enable Reg -----------------------------*/
#define CAN_ERROR_BUSOFF_INT_ENABLE             (1<<7)
#define CAN_ARBITR_LOST_INT_ENABLE              (1<<6)
#define CAN_ERROR_PASSIVE_INT_ENABLE            (1<<5)
#define CAN_WAKEUP_INT_ENABLE                   (1<<4)
#define CAN_OVERRUN_INT_ENABLE                  (1<<3)
#define CAN_ERROR_INT_ENABLE                    (1<<2)
#define CAN_TRANSMIT_INT_ENABLE                 (1<<1)
#define CAN_RECEIVE_INT_ENABLE                  (1<<0)

/*--- Interrupt Register -----------------------------------*/

#define CAN_WAKEUP_INT                          (1<<4)
#define CAN_OVERRUN_INT                         (1<<3)
#define CAN_ERROR_INT                           (1<<2)
#define CAN_TRANSMIT_INT                        (1<<1)
#define CAN_RECEIVE_INT                         (1<<0)

/*--- Mode Register -------- PeliCAN -------------------*/

#  define CAN_SLEEP_MODE                0x10    /* Sleep Mode */
#  define CAN_ACC_FILT_MASK             0x08    /* Acceptance Filter Mask */
#  define CAN_SELF_TEST_MODE            0x04    /* Self test mode */
#  define CAN_LISTEN_ONLY_MODE          0x02    /* Listen only mode */
#  define CAN_RESET_REQUEST             0x01    /* reset mode */
#  define CAN_MODE_DEF CAN_ACC_FILT_MASK         /* Default ModeRegister Value*/

   /* bit numbers of mode register */
#  define CAN_SLEEP_MODE_BIT            4       /* Sleep Mode */
#  define CAN_ACC_FILT_MASK_BIT         3       /* Acceptance Filter Mask */
#  define CAN_SELF_TEST_MODE_BIT        2       /* Self test mode */
#  define CAN_LISTEN_ONLY_MODE_BIT      1       /* Listen only mode */
#  define CAN_RESET_REQUEST_BIT         0       /* reset mode */

/*--- Status Register --------------------------------*/

#define CAN_BUS_STATUS                          (1<<7)
#define CAN_ERROR_STATUS                        (1<<6)
#define CAN_TRANSMIT_STATUS                     (1<<5)
#define CAN_RECEIVE_STATUS                      (1<<4)
#define CAN_TRANSMISSION_COMPLETE_STATUS        (1<<3)
#define CAN_TRANSMIT_BUFFER_ACCESS              (1<<2)
#define CAN_DATA_OVERRUN                        (1<<1)
#define CAN_RECEIVE_BUFFER_STATUS               (1<<0)

/*--- Status Register --------------------------------*/

#define CAN_BUS_STATUS_BIT                      (1<<7)
#define CAN_ERROR_STATUS_BIT                    (1<<6)
#define CAN_TRANSMIT_STATUS_BIT                 (1<<5)
#define CAN_RECEIVE_STATUS_BIT                  (1<<4)
#define CAN_TRANSMISSION_COMPLETE_STATUS_BIT    (1<<3)
#define CAN_TRANSMIT_BUFFER_ACCESS_BIT          (1<<2)
#define CAN_DATA_OVERRUN_BIT                    (1<<1)
#define CAN_RECEIVE_BUFFER_STATUS_BIT           (1<<0)

/*--- Frame information register -----------------------*/
#define CAN_EFF                         0x80    /* extended frame */
#define CAN_SFF                         0x00    /* standard fame format */

/*--- Command Register ------------------------------------*/

#define CAN_GOTO_SLEEP                          (1<<4)
#define CAN_CLEAR_OVERRUN_STATUS                (1<<3)
#define CAN_RELEASE_RECEIVE_BUFFER              (1<<2)
#define CAN_ABORT_TRANSMISSION                  (1<<1)
#define CAN_TRANSMISSION_REQUEST                (1<<0)

/*--- Clock Divider register ---------------------------------*/

#define CAN_MODE_BASICCAN               (0x00)
#define CAN_MODE_PELICAN                (0xC0)
#define CAN_MODE_CLK                    (0x07)          /* CLK-out = Fclk   */
#define CAN_MODE_CLK2                   (0x00)          /* CLK-out = Fclk/2 */

/*--- Remote Request ---------------------------------*/
/*    Notes:
 *    Basic CAN: RTR is Bit 4 in TXDES1.
 *    Peli  CAN: RTR is Bit 6 in frameinfo.
 */
# define CAN_RTR                                (1<<6)


#define CAN_OUTC_VAL           	        0x1a
#define STD_MASK			0xFFFFFFFF

#  define CAN_TIM0_10K            49
#  define CAN_TIM1_10K          0x1c
#  define CAN_TIM0_20K            24
#  define CAN_TIM1_20K          0x1c
#  define CAN_TIM0_40K          0x89    /* Old Bit Timing Standard of port */
#  define CAN_TIM1_40K          0xEB    /* Old Bit Timing Standard of port */
#  define CAN_TIM0_50K             9
#  define CAN_TIM1_50K          0x1c
#  define CAN_TIM0_100K              4    /* sp 87%, 16 abtastungen, sjw 1 */
#  define CAN_TIM1_100K           0x1c
#  define CAN_TIM0_125K            3
#  define CAN_TIM1_125K         0x1c
#  define CAN_TIM0_250K            1
#  define CAN_TIM1_250K         0x1c
#  define CAN_TIM0_500K            0
#  define CAN_TIM1_500K         0x1c
#  define CAN_TIM0_800K            0
#  define CAN_TIM1_800K         0x16
#  define CAN_TIM0_1000K           0
#  define CAN_TIM1_1000K        0x14

typedef unsigned char uint8;

typedef struct CanStatusPar {
    unsigned int baud;                  /**< actual bit rate */
    unsigned int status;                /**< CAN controller status register */
    unsigned int error_warning_limit;   /**< the error warning limit */
    unsigned int rx_errors;             /**< content of RX error counter */
    unsigned int tx_errors;             /**< content of TX error counter */
    unsigned int error_code;            /**< content of error code register */
    unsigned int rx_buffer_size;        /**< size of rx buffer  */
    unsigned int rx_buffer_used;        /**< number of messages */
    unsigned int tx_buffer_size;        /**< size of tx buffer  */
    unsigned int tx_buffer_used;        /**< number of messages */
    //unsigned long retval;               /**< return value */
    unsigned int type;                  /**< CAN controller / driver type */
} CanStatusPar_t;

typedef struct {
    /** flags, indicating or controlling special message properties */
    unsigned char flags;
    //int             cob;         /**< CAN object number, used in Full CAN  */
    unsigned long id;          /**< CAN message ID, 4 bytes  */
    //struct timeval  timestamp;   /**< time stamp for received messages */
    unsigned char  length;      /**< number of bytes in the CAN message */
    unsigned char data[CAN_MSG_LENGTH]; /**< data, 0...8 bytes */
} canmsg_t;

typedef struct {
        int head;
        int tail;
        int status;
        int active;
        char free[MAX_BUFSIZE];
        canmsg_t data[MAX_BUFSIZE];
} canfifo_t;

typedef struct can_devinfo {
        canfifo_t tx_buf;
        canfifo_t rx_buf;
        unsigned int baud;
        unsigned int ocr;
	__u32 acr;
	__u32 amr;
	unsigned int timestamp;
}can_devinfo_t;

