/* Declarations for PISO-CAN200

   Author: Reed Lai

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */

/* File level history (record changes for this file here.
 
   *** Do not include this file in your code. ***

   v 0.0.0 10 Sep 2008 by Golden Wang
     create, blah blah... */

#ifndef _PISOCAN400_H
#define _PISOCAN400_H

#define MODULE_NAME "ixpisocan200"

#define INT_MASK_SHIFT_STOP_BIT  0x10

/* offset of registers */
#define MOD    0
#define CMR    1
#define SR     2
#define IR     3
#define IER    4
#define BTR0   6
#define BTR1   7
#define OCR    8
#define ALC   11
#define ECC   12
#define EWLR  13
#define RXERR 14
#define TXERR 15
#define PACR  16

#define EXTINF 16

#define RFINF 16
#define TFINF 16
#define PRBUF 17
#define PTBUF 17
#define TFID1 17
#define TFID2 18
#define TFID3 19
#define TFID4 20
#define RFID1 17
#define RFID2 18
#define RFID3 19
#define RFID4 20

#define EXTID1 17
#define EXTID2 18
#define EXTID3 19
#define EXTID4 20
#define EXTDATA 21

#define TFSFDB 19
#define TFEFDB 21
#define RFSFDB 19
#define RFEFDB 21
#define PAMR  20
#define RMC   29
#define RBSA  30
#define CDR   31

/* mask of registers (16-bit operation) */

#define _8254C0_MASK  0xffff
#define _8254C1_MASK  0xffff
#define _8254C2_MASK  0xffff
#define _8254CR_MASK  0xffff
#define _CR_MASK      0xbfdf
#define _SR_MASK      0x00ff
#define _ADST_MASK    0xffff
#define _DI_MASK      0xffff
#define _DO_MASK      0xffff
#define _AD_MASK      0x0fff
#define _DA1_MASK     0x0fff
#define _DA2_MASK     0x0fff

#endif							

wait_queue_head_t CanWait[DEVICE_NR_DEVS][4];
wait_queue_head_t CanOutWait[DEVICE_NR_DEVS][4];
spinlock_t write_splock[DEVICE_NR_DEVS][4];
int CanWaitFlag[DEVICE_NR_DEVS][4];
void *viraddr[DEVICE_NR_DEVS] = {0};
