/* Example of CAN for PISO-CAN400-D/T

   Author: Golden Wang

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */

/* File level history (record changes for this file here.)

   v 0.0.0 1 May 2009 by Golden Wang
     create, blah blah... */

#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <sys/ioctl.h>
#include <unistd.h>
#include <string.h>

#include "ixpci.h"
#include "pisocan.h"


int main()
{
	int fd1,fd2,fd3,fd4;
	ixpci_canreg_t sr1 = {0};
        ixpci_canreg_t sr2 = {0};
	char *dev_file1,*dev_file2, *dev_file3,*dev_file4;
	int i, send,read;
	int rx_count;
	
	dev_file1 = "/dev/ixpci-can1";
	dev_file2 = "/dev/ixpci-can2";
	dev_file3 = "/dev/ixpci-can3";
	dev_file4 = "/dev/ixpci-can4";

	/* get library version and driver version */
        printf("CAN driver version : %s\n",CAN_GetDriverVersion());
        printf("CAN library version : %s\n",CAN_GetLibraryVersion());

	/* open device */

	fd1 = CAN_Open(dev_file1);

	if (fd1 < 0) {
		printf("Cannot open device file \"%s.\"\n", dev_file1);
		return FAILURE;
	}
	
	fd2 = CAN_Open(dev_file2);

        if (fd2 < 0) {
                printf("Cannot open device file \"%s.\"\n", dev_file2);
                return FAILURE;
        }

	fd3 = CAN_Open(dev_file3);

        if (fd3 < 0) {
                printf("Cannot open device file \"%s.\"\n", dev_file3);
                return FAILURE;
        }

	fd4 = CAN_Open(dev_file4);

        if (fd4 < 0) {
                printf("Cannot open device file \"%s.\"\n", dev_file4);
                return FAILURE;
        }

	
	do{
		printf("\nPress 'Enter' to send data from Port 1 and Port 3\n");

		getchar();

		//send data from Port 1
                //sr1.tx.flags = MSG_EXT | MSG_RTR; //Extended frame and RTR = 1
                sr1.tx.flags = MSG_STD;             //Standard frame and RTR = 0
                sr1.tx.length = 8;
                sr1.tx.id=0x123;
                sr1.tx.data[0] = 0x11;
                sr1.tx.data[1] = 0x12;
                sr1.tx.data[2] = 0x13;
                sr1.tx.data[3] = 0x14;
                sr1.tx.data[4] = 0x15;
                sr1.tx.data[5] = 0x16;
                sr1.tx.data[6] = 0x17;
                sr1.tx.data[7] = 0x18;

		send = CAN_SendMsgWithoutIrq(fd1, &sr1);

		if ( send == CAN_NOERROR )
                {
                        printf("\n*** Send DATA from Port 1 ***\n");
                        printf("TX id=%x len=%x flags=0x%x \n",
                                sr1.tx.id, sr1.tx.length, sr1.tx.flags);
                        printf("TX DATA=%x%x%x%x%x%x%x%x\n",
                                sr1.tx.data[0], sr1.tx.data[1], sr1.tx.data[2],
                                sr1.tx.data[3], sr1.tx.data[4], sr1.tx.data[5],
                                sr1.tx.data[6], sr1.tx.data[7]);
                }
                else
                {
                        printf("Send DATA from Port 1 fail!\n");
                }

		//send data from Port 3
		//sr2.tx.flags = MSG_EXT | MSG_RTR; //Extended frame and RTR = 1
                sr2.tx.flags = MSG_STD;             //Standard frame and RTR = 0
                sr2.tx.length = 8;
                sr2.tx.id=0x130;
                sr2.tx.data[0] = 0x31;
                sr2.tx.data[1] = 0x32;
                sr2.tx.data[2] = 0x33;
                sr2.tx.data[3] = 0x34;
                sr2.tx.data[4] = 0x35;
                sr2.tx.data[5] = 0x36;
                sr2.tx.data[6] = 0x37;
                sr2.tx.data[7] = 0x38;

		send = CAN_SendMsgWithoutIrq(fd3, &sr2);

		if ( send == CAN_NOERROR )
                {
                        printf("\n*** Send DATA from Port 3 ***\n");
                        printf("TX id=%x len=%x flags=0x%x \n",
                                sr2.tx.id, sr2.tx.length, sr2.tx.flags);
                        printf("TX DATA=%x%x%x%x%x%x%x%x\n",
                                sr2.tx.data[0], sr2.tx.data[1], sr2.tx.data[2],
                                sr2.tx.data[3], sr2.tx.data[4], sr2.tx.data[5],
                                sr2.tx.data[6], sr2.tx.data[7]);
                }
                else
                {
                        printf("Send DATA from Port 3 fail!\n");
                }

		printf("\n\nPress 'Enter' to read data from Port 2 and Port 4\n");

		getchar();

		//read data from Port 2
                printf("\n*** Read DATA from Port 2 ***\n");

		rx_count = CAN_RxMsgCount(fd2);
                printf("Port 2 RX message count : %d\n",rx_count);

		read = CAN_ReceiveMsgWithoutIrq(fd2, &sr1);

                if ( read == CAN_NOERROR )
                {
                        printf("RX id=%x len=%x flags=0x%x \n",
                                sr1.rx.id, sr1.rx.length, sr1.rx.flags);
                        printf("RX DATA=%x%x%x%x%x%x%x%x\n",
                                sr1.rx.data[0], sr1.rx.data[1], sr1.rx.data[2],
                                sr1.rx.data[3], sr1.rx.data[4], sr1.rx.data[5],
                                sr1.rx.data[6], sr1.rx.data[7]);
                }
                else
                {
                        printf("No data in Port 2 RX buffer\n");
                }

		//read data from Port 4
                printf("\n*** Read DATA from Port 4 ***\n");

		rx_count = CAN_RxMsgCount(fd4);
                printf("Port 4 RX message count : %d\n",rx_count);

		read = CAN_ReceiveMsgWithoutIrq(fd4, &sr2);

                if ( read == CAN_NOERROR )
                {
                        printf("RX id=%x len=%x flags=0x%x \n",
				sr2.rx.id, sr2.rx.length, sr2.rx.flags);
                        printf("RX DATA=%x%x%x%x%x%x%x%x\n",
				sr2.rx.data[0], sr2.rx.data[1], sr2.rx.data[2],
				sr2.rx.data[3], sr2.rx.data[4], sr2.rx.data[5],
				sr2.rx.data[6], sr2.rx.data[7]);
                }
                else
                {
                        printf("No data in Port 4 RX buffer\n");
                }

		printf("\nPress 'Esc' to quit or Press 'Enter' to run again\n");
	}while (getchar() != 27);
	
	CAN_Close(fd4);
        CAN_Close(fd3);
	CAN_Close(fd2);
        CAN_Close(fd1);

	return SUCCESS;
}
