/* Example of CAN for PISO-CAN400-D/T

   Author: Golden Wang

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */

/* File level history (record changes for this file here.)

   v 0.0.0 1 May 2009 by Golden Wang
     create, blah blah... */

#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <sys/ioctl.h>
#include <unistd.h>
#include <string.h>

#include "ixpci.h"
#include "pisocan.h"

int main()
{
	int fd1,fd2;
	char *dev_file1, *dev_file2;
	unsigned int acr, amr;
	unsigned int baud[8] = {10, 20, 50, 125, 250, 500, 800, 1000};
	int h = 0, i = 0, j = 0, k = 0, success = 0, failure = 0, rs;
	int index = 0;
	int rx_count, count = 100;
	int msg_id = 0x100;
	unsigned char msg_data[8] = {0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08};
	canmsg_t tx1[256];
	canmsg_t rx2[256];
	
	dev_file1 = "/dev/ixpci-can1";
        dev_file2 = "/dev/ixpci-can2";

	/* get library version and driver version */
        printf("CAN driver version : %s\n",CAN_GetDriverVersion());
        printf("CAN library version : %s\n",CAN_GetLibraryVersion());


	/* init device file ixpci-can1,2,3,4 */
	
	fd1 = CAN_Open(dev_file1);

	if (fd1 < 0) {
		printf("Cannot open device file \"%s.\"\n", dev_file1);
		return FAILURE;
	}

	fd2 = CAN_Open(dev_file2);

        if (fd2 < 0) {
                printf("Cannot open device file \"%s.\"\n", dev_file2);
                return FAILURE;
        }

	//Enable Port 2 RX Interrupt

        if ( !CAN_RxIrqStatus(fd2) )
        {
		rs = CAN_EnableRxIrq(fd2);

	        if ( rs == CAN_ENABLERXIRQ_ERROR )
        	        return FAILURE;
        }

	/* ready to send and receive CAN message */

	do
	{
		//Config Port 1, 2 ACR = 0, AMR = 0xffffffff
	        //Baud Rate : 10K, 20K, 50K, 125K, 250K, 500K, 800K, 1M
	        acr = 0;
        	amr = 0xffffffff;

	        rs = CAN_Config(fd1, baud[h], acr, amr);

        	if ( rs == CAN_CONFIG_ERROR )
                	return FAILURE;

	        rs = CAN_Config(fd2, baud[h], acr, amr);

        	if ( rs == CAN_CONFIG_ERROR )
                	return FAILURE;

		//printf("\nSend 10000 data from Port 1\n");
		//getchar();

		for ( i = 0; i < count; i++)
		{
			msg_id = msg_id + 1;
			
			for ( k = 0; k < 8 ; k++ )
			{
				msg_data[k] = msg_data[k] + 1;
			}

			for ( j = 0; j < count; j++)
			{
				tx1[j].flags = MSG_STD;		  
	        		tx1[j].length = 8;
	        
				tx1[j].id = msg_id;
			        tx1[j].data[0] = msg_data[0];
			        tx1[j].data[1] = msg_data[1];
	        		tx1[j].data[2] = msg_data[2];
		        	tx1[j].data[3] = msg_data[3];
		        	tx1[j].data[4] = msg_data[4];
	        		tx1[j].data[5] = msg_data[5];
		        	tx1[j].data[6] = msg_data[6];
		        	tx1[j].data[7] = msg_data[7];
			}
			
			rs = CAN_SendMsgWithIrq(fd1, tx1, count);

			if ( rs == CAN_SENDMSG_WITHIRQ_ERROR )
                        	printf("Send DATA from Port 1 failure\n");

                	sleep(2);

			//rx_count = CAN_RxMsgCount(fd2);
        	        //printf("Port 2 RX message count : %d\n",rx_count);

                	rs = CAN_ReceiveMsgWithIrq(fd2, rx2, count);

			if ( rs == CAN_RECEIVEMSG_WITHIRQ_ERROR )
		        {
		        	printf("Read DATA from Port 2 failure\n");
                	}
                	else
                	{
				for ( k = 0; k < count; k++)
		        	{
/*
                			if ( tx1[k].id == rx2[k].id &&
                                	     tx1[k].length == rx2[k].length &&
                                     	     tx1[k].flags == rx2[k].flags &&
		                             tx1[k].data[0] == rx2[k].data[0] &&
                		             tx1[k].data[1] == rx2[k].data[1] &&
                                	     tx1[k].data[2] == rx2[k].data[2] &&
		                             tx1[k].data[3] == rx2[k].data[3] &&
		                             tx1[k].data[4] == rx2[k].data[4] &&
		                             tx1[k].data[5] == rx2[k].data[5] &&
		                             tx1[k].data[6] == rx2[k].data[6] &&
		                             tx1[k].data[7] == rx2[k].data[7] )
*/
/*
					printf("TX id=%x len=%x flags=0x%x \n",
		                                tx1[k].id, tx1[k].length, tx1[k].flags);
                		        printf("TX DATA%d=%02x%x%x%x%x%x%x%x\n\n", (i+1),
                                		tx1[k].data[0], tx1[k].data[1], tx1[k].data[2],
		                                tx1[k].data[3], tx1[k].data[4], tx1[k].data[5],
		                                tx1[k].data[6], tx1[k].data[7]);
				
					printf("RX id=%x len=%x flags=0x%x \n",
		                                rx2[k].id, rx2[k].length, rx2[k].flags);
                		        printf("RX DATA%d=%02x%x%x%x%x%x%x%x\n\n", (i+1),
                                		rx2[k].data[0], rx2[k].data[1], rx2[k].data[2],
		                                rx2[k].data[3], rx2[k].data[4], rx2[k].data[5],
		                                rx2[k].data[6], rx2[k].data[7]);
*/
					if ( tx1[k].id != rx2[k].id ||
                                             tx1[k].length != rx2[k].length ||
                                             tx1[k].flags != rx2[k].flags ||
                                             tx1[k].data[0] != rx2[k].data[0] ||
                                             tx1[k].data[1] != rx2[k].data[1] ||
                                             tx1[k].data[2] != rx2[k].data[2] ||
                                             tx1[k].data[3] != rx2[k].data[3] ||
                                             tx1[k].data[4] != rx2[k].data[4] ||
                                             tx1[k].data[5] != rx2[k].data[5] ||
                                             tx1[k].data[6] != rx2[k].data[6] ||
                                             tx1[k].data[7] != rx2[k].data[7] )
                		        {
                                		failure++;
                                	}
		                        else
                		        {
                                		success++;
                                	}
				}
			}
			printf("Now CAN Data(baud : %d) : %d\n", baud[h],(success+failure));

		}
	
		printf("Test Result(baud : %d) : Success : %d  Failure : %d\n\n", baud[h],success, failure);

		msg_id = 0x100;
                msg_data[0] = 0x01;
                msg_data[1] = 0x02;
                msg_data[2] = 0x03;
                msg_data[3] = 0x04;
                msg_data[4] = 0x05;
                msg_data[5] = 0x06;
                msg_data[6] = 0x07;
                msg_data[7] = 0x08;
		success = 0;
		failure = 0;

		h++;	//change baud rate
	}while(h<8);


	//Disable Port 2,4 RX Interrupt
        CAN_DisableRxIrq(fd2);
        if ( rs == CAN_DISABLERXIRQ_ERROR )
                return FAILURE;

	CAN_Close(fd2);
        CAN_Close(fd1);

	return SUCCESS;
}
