/* Example of CAN for PISO-CAN400-D/T

   Author: Golden Wang

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */

/* File level history (record changes for this file here.)

   v 0.0.0 1 May 2009 by Golden Wang
     create, blah blah... */

#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <sys/ioctl.h>
#include <unistd.h>
#include <string.h>

#include "ixpci.h"


int main()
{
	int fd1,fd2,fd3,fd4;
	ixpci_canreg_t sr;
	char *dev_file1, *dev_file2, *dev_file3, *dev_file4;
	int i = 0, sent;
	int index = 0;
	canmsg_t tx1[256];
	canmsg_t tx3[256];
	canmsg_t rx2[256];
	canmsg_t rx4[256];
	
	dev_file1 = "/dev/ixpci-can1";
        dev_file2 = "/dev/ixpci-can2";
        dev_file3 = "/dev/ixpci-can3";
        dev_file4 = "/dev/ixpci-can4";

	printf("\nStart to init device file ixpci-can1,2,3,4\n"); 

	
	fd1 = open(dev_file1, O_RDWR);

	if (fd1 < 0) {
		printf("Cannot open device file \"%s.\"\n", dev_file1);
		return FAILURE;
	}

        fd2 = open(dev_file2, O_RDWR);

        if (fd2 < 0) {
                printf("Cannot open device file \"%s.\"\n", dev_file2);
                return FAILURE;
        }

	fd3 = open(dev_file3, O_RDWR);

        if (fd3 < 0) {
                printf("Cannot open device file \"%s.\"\n", dev_file3);
                return FAILURE;
        }

	fd4 = open(dev_file4, O_RDWR);

        if (fd4 < 0) {
                printf("Cannot open device file \"%s.\"\n", dev_file4);
                return FAILURE;
        }
	
	printf("End to init device file ixpci-can1,2,3,4\n"); 
	// Enable PLX Interrupt

	if (ioctl(fd1, IXPCI_IRQ_ENABLE)) {
                close(fd1);
                puts("Failure of enabling board irq.");
                return FAILURE;
        }

/*	//default open system call would enable TX Interrupt
	sr.id = IXPCI_CAN_ENABLETXIRQ;
        ioctl(fd1, IXPCI_WRITE_REG, &sr); sleep(1);

	sr.id = IXPCI_CAN_ENABLETXIRQ;
        ioctl(fd3, IXPCI_WRITE_REG, &sr); sleep(1);
*/

	//Config Port 3, 4 baud = 500, ACR = 0, AMR = 0xffffffff
	
	sr.id = IXPCI_CAN_CONFIG;
	sr.baud = 500;
	sr.acr = 0;
	sr.amr = 0xffffffff;

	ioctl(fd3, IXPCI_WRITE_REG, &sr); 
	ioctl(fd4, IXPCI_WRITE_REG, &sr);

	//Enable Port 2, 4 RX Interrupt

	printf("Start to enable Port 2,4 RX Interrupt\n");

	sr.id = IXPCI_CAN_ENABLERXIRQ;
        ioctl(fd2, IXPCI_WRITE_REG, &sr); 

	sr.id = IXPCI_CAN_ENABLERXIRQ;
       	ioctl(fd4, IXPCI_WRITE_REG, &sr);

	printf("End to enable Port 2,4 RX Interrupt\n");


	do
	{
		printf("\nPress 'Enter' to send three data from Port 1 and Port 3\n");
		getchar();

		for ( i = 0; i < 3; i++)
		{
			//tx1[i].flags = MSG_EXT | MSG_RTR; //Extended frame and RTR = 1
			tx1[i].flags = MSG_STD;		    //Standard frame and RTR = 0
	        	tx1[i].length = 8;
	        	tx1[i].id=0x123 + i;
		        tx1[i].data[0] = 0x11;
		        tx1[i].data[1] = 0x12;
	        	tx1[i].data[2] = 0x13;
		        tx1[i].data[3] = 0x14;
		        tx1[i].data[4] = 0x15;
	        	tx1[i].data[5] = 0x16;
		        tx1[i].data[6] = 0x17;
		        tx1[i].data[7] = 0x18;

			//tx3[i].flags = MSG_EXT | MSG_RTR; //Extended frame and RTR = 1
                        tx3[i].flags = MSG_STD;             //Standard frame and RTR = 0
                        tx3[i].length = 8;
                        tx3[i].id=0x130 + i;
                        tx3[i].data[0] = 0x31;
                        tx3[i].data[1] = 0x32;
                        tx3[i].data[2] = 0x33;
                        tx3[i].data[3] = 0x34;
                        tx3[i].data[4] = 0x35;
                        tx3[i].data[5] = 0x36;
                        tx3[i].data[6] = 0x37;
                        tx3[i].data[7] = 0x38;

		}

		for ( i = 0; i < 3; i++)
		{
		
			printf("*** Send DATA%d from Port 1 ***\n", (i+1));
			printf("TX id=%x len=%x flags=0x%x \n",
				tx1[i].id, tx1[i].length, tx1[i].flags);
	        	printf("TX DATA%d=%02x%x%x%x%x%x%x%x\n\n", (i+1),
				tx1[i].data[0], tx1[i].data[1], tx1[i].data[2],
				tx1[i].data[3], tx1[i].data[4], tx1[i].data[5],
				tx1[i].data[6], tx1[i].data[7]);
		}
        	
		write(fd1, tx1, 3 ); 

		for ( i = 0; i < 3; i++)
                {
			printf("*** Send DATA%d from Port 3 ***\n", (i+1));
                        printf("TX id=%x len=%x flags=0x%x \n",
				tx3[i].id, tx3[i].length, tx3[i].flags);
                        printf("TX DATA%d=%02x%x%x%x%x%x%x%x\n\n", (i+1),
				tx3[i].data[0], tx3[i].data[1], tx3[i].data[2],
				tx3[i].data[3], tx3[i].data[4], tx3[i].data[5],
				tx3[i].data[6], tx3[i].data[7]);
		}
	
        	write(fd3, tx3, 3 );

		printf("\nPress 'Enter' to receive data from Port 2 and Port 4\n");

		getchar();

		printf("*** Receive DATA from Port 2 ***\n");

        	read(fd2, &rx2, 3);

        	for ( i = 0; i < 3; i++)
        	{
                	printf("RX id=%x len=%x flags=0x%x \n",
				rx2[i].id, rx2[i].length, rx2[i].flags);
                	printf("RX DATA%d=%x%x%x%x%x%x%x%x\n\n", (i+1),
				rx2[i].data[0], rx2[i].data[1], rx2[i].data[2],
				rx2[i].data[3], rx2[i].data[4], rx2[i].data[5],
				rx2[i].data[6], rx2[i].data[7]);
        	}

		printf("*** Receive DATA from Port 4 ***\n");
        	read(fd4, &rx4, 3);
		for ( i = 0; i < 3; i++)
                {
                        printf("RX id=%x len=%x flags=0x%x \n",
                                rx4[i].id, rx4[i].length, rx4[i].flags);
                        printf("RX DATA%d=%x%x%x%x%x%x%x%x\n\n", (i+1),
                                rx4[i].data[0], rx4[i].data[1], rx4[i].data[2],
                                rx4[i].data[3], rx4[i].data[4], rx4[i].data[5],
                                rx4[i].data[6], rx4[i].data[7]);
                }

		printf("\nPress 'Esc' to quit or Press 'Enter' to run again\n");
	}while((getchar() != 27));


	printf("\nStart to disable Port 2,4 RX Interrupt\n");

	sr.id = IXPCI_CAN_DISABLERXIRQ;
        ioctl(fd2, IXPCI_WRITE_REG, &sr); sleep(1);

        sr.id = IXPCI_CAN_DISABLERXIRQ;
        ioctl(fd4, IXPCI_WRITE_REG, &sr); sleep(1);
	printf("End to disable Port 2,4 RX Interrupt\n");

	close(fd4);
	close(fd3);
	close(fd2);
	close(fd1);
	return SUCCESS;
}
