/* Example of CAN for PISO-CAN400-D/T

   Author: Golden Wang

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */

/* File level history (record changes for this file here.)

   v 0.0.0 1 May 2009 by Golden Wang
     create, blah blah... */

#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <sys/ioctl.h>
#include <unistd.h>
#include <string.h>

#include "ixpci.h"


int main()
{
	int fd_dev;
	ixpci_canreg_t sr;
	char *dev_file;
	char *m;
	
	dev_file = "/dev/ixpci-can2";
		/* change this for your device entry */

	/* open device */
	fd_dev = open(dev_file, O_RDWR);

	if (fd_dev < 0) {
		printf("Cannot open device file \"%s.\"\n", dev_file);
		return FAILURE;
	}

	/* read status register */
        sr.id = IXPCI_CAN_STATUS;

        if (ioctl(fd_dev, IXPCI_READ_REG, &sr))
        {  /* read SR */
                puts("Failure of ioctl command IXPCI_RRITE_REG: IXPCI_CANSR.");
                return FAILURE;
        }


	switch(sr.stat.type){
		case  CAN_TYPE_SJA1000:
			m = "sja1000";
			break;
		case CAN_TYPE_UNSPEC:
		default:
			m = "unknown";
			break;
	}

	printf("CAN Chip: %s Status register : 0x%x Baud: %d tx:%3d/%3d: rx:%3d/%3d:\n",
        m,
	sr.stat.status,
        sr.stat.baud,
        sr.stat.tx_buffer_size,
        sr.stat.tx_buffer_used,
        sr.stat.rx_buffer_size,
        sr.stat.rx_buffer_used
        );

        //printf("CAN port 1 status : %x\n", sr.value);

	close(fd_dev);
	return SUCCESS;
}
