/* Example of CAN for PISO-CAN400-D/T

   Author: Golden Wang

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */

/* File level history (record changes for this file here.)

   v 0.0.0 1 May 2009 by Golden Wang
     create, blah blah... */

#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <sys/ioctl.h>
#include <unistd.h>
#include <string.h>

#include "ixpci.h"
#include "pisocan.h"


int main()
{
	int fd1,fd2,fd3,fd4;
	char *dev_file1, *dev_file2, *dev_file3, *dev_file4;
	int irqstatus1, irqstatus2, irqstatus3, irqstatus4;
	
	dev_file1 = "/dev/ixpci-can1";
        dev_file2 = "/dev/ixpci-can2";
        dev_file3 = "/dev/ixpci-can3";
        dev_file4 = "/dev/ixpci-can4";

	/* get library version and driver version */
	printf("CAN driver version : %s\n",CAN_GetDriverVersion());
        printf("CAN library version : %s\n",CAN_GetLibraryVersion());

	/* init pisocan400 port 1,2,3,4 */
	fd1 = CAN_Open(dev_file1);	

	if (fd1 < 0) {
		printf("Cannot open device file \"%s.\"\n", dev_file1);
		return FAILURE;
	}

	fd2 = CAN_Open(dev_file2);	

        if (fd2 < 0) {
                printf("Cannot open device file \"%s.\"\n", dev_file2);
                return FAILURE;
        }

	fd3 = CAN_Open(dev_file3);

        if (fd3 < 0) {
                printf("Cannot open device file \"%s.\"\n", dev_file3);
                return FAILURE;
        }

        fd4 = CAN_Open(dev_file4);

        if (fd4 < 0) {
                printf("Cannot open device file \"%s.\"\n", dev_file4);
                return FAILURE;
        }

        //Check Port 1,2,3,4 IRQ status

	printf("\n");
	irqstatus1 = CAN_IrqStatus(fd1);

	if ( irqstatus1 & CAN_OVERRUN_IRQ )
		printf("CAN Port 1 Overrun IRQ Status : enabled\n");
	else
		printf("CAN Port 1 Overrun IRQ Status : disabled\n");

	if ( irqstatus1 & CAN_TRANSMIT_IRQ )
                printf("CAN Port 1 Transmit IRQ Status : enabled\n");
        else
                printf("CAN Port 1 Transmit IRQ Status : disabled\n");

	if ( irqstatus1 & CAN_RECEIVE_IRQ )
                printf("CAN Port 1 Receive IRQ Status : enabled\n");
        else
                printf("CAN Port 1 Receive IRQ Status : disabled\n");

	printf("\n");
	irqstatus2 = CAN_IrqStatus(fd2);

	if ( irqstatus2 & CAN_OVERRUN_IRQ )
                printf("CAN Port 2 Overrun IRQ Status : enabled\n");
        else
                printf("CAN Port 2 Overrun IRQ Status : disabled\n");

        if ( irqstatus2 & CAN_TRANSMIT_IRQ )
                printf("CAN Port 2 Transmit IRQ Status : enabled\n");
        else
                printf("CAN Port 2 Transmit IRQ Status : disabled\n");

        if ( irqstatus2 & CAN_RECEIVE_IRQ )
                printf("CAN Port 2 Receive IRQ Status : enabled\n");
        else
                printf("CAN Port 2 Receive IRQ Status : disabled\n");


	printf("\n");
	irqstatus3 = CAN_IrqStatus(fd3);

        if ( irqstatus3 & CAN_OVERRUN_IRQ )
                printf("CAN Port 3 Overrun IRQ Status : enabled\n");
        else
                printf("CAN Port 3 Overrun IRQ Status : disabled\n");

        if ( irqstatus3 & CAN_TRANSMIT_IRQ )
                printf("CAN Port 3 Transmit IRQ Status : enabled\n");
        else
                printf("CAN Port 3 Transmit IRQ Status : disabled\n");

        if ( irqstatus3 & CAN_RECEIVE_IRQ )
                printf("CAN Port 3 Receive IRQ Status : enabled\n");
        else
                printf("CAN Port 3 Receive IRQ Status : disabled\n");

	printf("\n");
	irqstatus4 = CAN_IrqStatus(fd4);

        if ( irqstatus4 & CAN_OVERRUN_IRQ )
                printf("CAN Port 4 Overrun IRQ Status : enabled\n");
        else
                printf("CAN Port 4 Overrun IRQ Status : disabled\n");

        if ( irqstatus4 & CAN_TRANSMIT_IRQ )
                printf("CAN Port 4 Transmit IRQ Status : enabled\n");
        else
                printf("CAN Port 4 Transmit IRQ Status : disabled\n");

        if ( irqstatus4 & CAN_RECEIVE_IRQ )
                printf("CAN Port 4 Receive IRQ Status : enabled\n");
        else
                printf("CAN Port 4 Receive IRQ Status : disabled\n");

	CAN_Close(fd4);
        CAN_Close(fd3);
	CAN_Close(fd2);
        CAN_Close(fd1);

	return SUCCESS;
}
