/* Example of CAN for PISO-CAN200-D/T

   Author: Golden Wang

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */

/* File level history (record changes for this file here.)

   v 0.0.0 1 May 2009 by Golden Wang
     create, blah blah... */

#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <sys/ioctl.h>
#include <unistd.h>
#include <string.h>

#include "ixpci.h"


int main()
{
	int fd1,fd2;
	ixpci_canreg_t sr = {0};
	char *dev_file1,*dev_file2;
	int i, send,read;
	
	dev_file1 = "/dev/ixpci-can1";
	dev_file2 = "/dev/ixpci-can2";

	/* open device */

	fd1 = open(dev_file1, O_RDWR);

	if (fd1 < 0) {
		printf("Cannot open device file \"%s.\"\n", dev_file1);
		return FAILURE;
	}
	
	fd2 = open(dev_file2, O_RDWR);

        if (fd2 < 0) {
                printf("Cannot open device file \"%s.\"\n", dev_file2);
                return FAILURE;
        }

	do{
		printf("\nPress 'Enter' to send data from Port 1\n");

		getchar();

		//send data from Port 1
                //sr.tx.flags = MSG_EXT | MSG_RTR; //Extended frame and RTR = 1
                sr.tx.flags = MSG_STD;             //Standard frame and RTR = 0
                sr.tx.length = 8;
                sr.tx.id=0x123;
                sr.tx.data[0] = 0x11;
                sr.tx.data[1] = 0x12;
                sr.tx.data[2] = 0x13;
                sr.tx.data[3] = 0x14;
                sr.tx.data[4] = 0x15;
                sr.tx.data[5] = 0x16;
                sr.tx.data[6] = 0x17;
                sr.tx.data[7] = 0x18;

                sr.id = IXPCI_CAN_SENDMSG;

                send = ioctl(fd1, IXPCI_WRITE_REG, &sr); 

                if ( send == SUCCESS )
                {
                        printf("\n*** Send DATA from Port 1 ***\n");
                        printf("TX id=%x len=%x flags=0x%x \n",
                                sr.tx.id, sr.tx.length, sr.tx.flags);
                        printf("TX DATA=%x%x%x%x%x%x%x%x\n",
                                sr.tx.data[0], sr.tx.data[1], sr.tx.data[2],
                                sr.tx.data[3], sr.tx.data[4], sr.tx.data[5],
                                sr.tx.data[6], sr.tx.data[7]);
                }
                else
                {
                        printf("Send DATA from Port 1 fail!\n");
                }

		printf("\n\nPress 'Enter' to read data from Port 2\n");

                getchar();
		//read data from Port 2
                printf("\n*** Read DATA from Port 2 ***\n");

                sr.id = IXPCI_CAN_RECEMSG;
                read = ioctl(fd2, IXPCI_READ_REG, &sr); 

                if ( read == SUCCESS )
                {
                        printf("RX id=%x len=%x flags=0x%x \n",
                                sr.rx.id, sr.rx.length, sr.rx.flags);
                        printf("RX DATA=%x%x%x%x%x%x%x%x\n",
                                sr.rx.data[0], sr.rx.data[1], sr.rx.data[2],
                                sr.rx.data[3], sr.rx.data[4], sr.rx.data[5],
                                sr.rx.data[6], sr.rx.data[7]);
                }
                else
                {
                        printf("No data in Port 2 RX buffer\n");
                }

		printf("\nPress 'Esc' to quit or Press 'Enter' to run again\n");
	}while (getchar() != 27);
	
	close(fd2);
	close(fd1);
	return SUCCESS;
}
