/* Read ADC result by software trigger.

   Author: Reed Lai

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */

/* File level history (record changes for this file here.)

   This program shows the AI by software trigger.

   v 0.0.0 21 Jan 2003 by Reed Lai
     Create */

#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <sys/ioctl.h>
#include <unistd.h>

#include "ixpci.h"

int main()
{
	int fd;
	char *dev_file;
	ixpci_reg_t reg, rai;

	dev_file = "/dev/ixpci1";

	/* open device file */
	fd = open(dev_file, O_RDWR);
	if (fd < 0) {
		printf("Failure of open device file \"%s.\"\n", dev_file);
		return FAILURE;
	}

	/* gain 1 */
	reg.id = IXPCI_AIGR;
	reg.value = 0;
	if (ioctl(fd, IXPCI_WRITE_REG, &reg)) {
		puts("Failure of gain control.");
		close(fd);
		return FAILURE;
	}

	/* software trigger mode */
	reg.id = IXPCI_CR;
	reg.value = 0;
	if (ioctl(fd, IXPCI_WRITE_REG, &reg)) {
		puts("Failure of software trigger mode.");
		close(fd);
		return FAILURE;
	}

	/* read 16 channels by software trigger */
	rai.id = IXPCI_AI;
	rai.mode = IXPCI_RM_TRIGGER;
	reg.id = IXPCI_AICR;

	puts("Enter to continue, ESC to exit.");
	while (getchar() != 27) {
		for (reg.value = 0; reg.value < 16; ++reg.value) {
			if (ioctl(fd, IXPCI_WRITE_REG, &reg)) {
				puts("Failure of ai channel selection.");
				close(fd);
				return FAILURE;
			}
			usleep(23);
				/* delay 23us for channel switching */

			if (ioctl(fd, IXPCI_READ_REG, &rai)) {
				puts("Failure of analog input.");
				close(fd);
				return FAILURE;
			}
			printf("%x ", rai.value);
		}
	}

	close(fd);
	return SUCCESS;
}
