unit  PISOCAN;          { pisocan.dll interface unit }

interface
type PSingle=^Single;
type PWord=^Word;
type DWORD=Cardinal;

type
   ConfigStruct = record
   AccCode : array[0..3] of BYTE;
   AccMask : array[0..3] of BYTE;
   BaudRate: BYTE;
   BTO: BYTE;
   BT1: BYTE;
End;

type
   PacketStruct = record
   MsgTimeStamps:Int64;
   mode: BYTE;
   id: DWORD;
   rtr: BYTE;
   len: BYTE;
   data: array[0..7] of BYTE;
   
End;


const
 CAN_NoError                   = 0;
 CAN_DriverError               = 1;
 CAN_ActiveBoardError          = 2;
 CAN_BoardNumberError          = 3;
 CAN_PortNumberError           = 4;
 CAN_ResetError                = 5;
 CAN_SoftResetError            = 6;
 CAN_InitError                 = 7;
 CAN_ConfigError               = 8;
 CAN_SetACRError               = 9;
 CAN_SetAMRError               = 10;
 CAN_SetBaudRateError          = 11;
 CAN_EnableRxIrqFailure        = 12;
 CAN_DisableRxIrqFailure       = 13;
 CAN_InstallIrqFailure         = 14;
 CAN_RemoveIrqFailure          = 15;
 CAN_TransmitBufferLocked      = 16;
 CAN_TransmitIncomplete        = 17;
 CAN_ReceiveBufferEmpty        = 18;
 CAN_DataOverrun               = 19;
 CAN_ReceiveError              = 20;
 CAN_SoftBufferIsEmpty         = 21;
 CAN_SoftBufferIsFull          = 22;
 CAN_TimeOut                   = 23;
 CAN_InstallIsrError			     = 24;

function CAN_GetDllVersion:WORD; StdCall;
function CAN_TotalBoard:WORD; StdCall;
function CAN_GetBoardInf( BoardNo:BYTE;Var dwVID:LongInt; Var dwDID:LongInt;Var dwSVID:LongInt;Var dwSDID:LongInt;Var dwSAuxID:LongInt;Var dwIrq:LongInt):Integer; StdCall;

function CAN_GetCardPortNum(BoardNo:BYTE; Var bGetPortNum:BYTE):Integer; StdCall;

function CAN_ActiveBoard( BoardN:BYTE):Integer; StdCall;
function CAN_CloseBoard( BoardNo:BYTE):Integer; StdCall;
function CAN_BoardIsActive( BoardNo:BYTE):Integer; StdCall;

function CAN_Reset( BoardNo:BYTE;Port:BYTE):Integer; Stdcall;
function CAN_Init( BoardNo:BYTE;Port:BYTE):Integer; Stdcall;
function CAN_Config( BoardNo:BYTE; Port:BYTE; Var CanConfig:ConfigStruct):Integer; Stdcall;
function CAN_ConfigWithoutStruct(BoardNo:BYTE; Port:BYTE; Var AccCode:DWORD; Var AccMask:DWORD; Var BaudRate:BYTE; Var BT0:BYTE; Var BT1:BYTE):Integer; Stdcall;

function CAN_EnableRxIrq( BoardNo:BYTE;Port:BYTE):Integer; Stdcall;
function CAN_DisableRxIrq( BoardNo:BYTE;Port:BYTE):Integer; Stdcall;
function CAN_RxIrqStatus( BoardNo:BYTE;Port:BYTE; Var bStatus: BYTE):Integer; Stdcall;
function CAN_InstallIrq( BoardNo:BYTE):Integer; Stdcall;
function CAN_RemoveIrq( BoardNo:BYTE):Integer; Stdcall;
function CAN_IrqStatus( BoardNo:BYTE; Var bStatus:BYTE):Integer; Stdcall;
function CAN_Status( BoardNo:BYTE;Port:BYTE; Var bStatus: BYTE):Integer; Stdcall;

function CAN_SendMsg( BoardNo:BYTE;Port:BYTE; Var CanPacket: PacketStruct):Integer; Stdcall;
function CAN_SendWithoutStruct( BoardNo:BYTE;Port:BYTE;mode:BYTE;id:DWORD;rtr:BYTE;len:BYTE; Var data:BYTE):Integer; Stdcall;

function CAN_RxMsgCount( BoardNo:BYTE;Port:BYTE):Integer; Stdcall;
function CAN_ReceiveMsg( BoardNo:BYTE;Port:BYTE; Var CanPacket: PacketStruct):Integer; Stdcall;
function CAN_ReceiveWithoutStruct( BoardNo:BYTE;Port:BYTE; Var mode:BYTE; Var id:DWORD; Var rtr:BYTE; Var len:BYTE; Var data:BYTE; Var H_MsgTimeStamps:DWORD; Var L_MsgTimeStamps:DWORD):Integer; Stdcall;

function CAN_ClearSoftBuffer( BoardNo:BYTE;Port:BYTE):Integer; Stdcall;
function CAN_ClearDataOverrun( BoardNo:BYTE;Port:BYTE):Integer; Stdcall;
function CAN_IntputByte( BoardNo:BYTE;Port:BYTE;wOffset:WORD):BYTE; Stdcall;
procedure CAN_OutputByte( BoardNo:BYTE;Port:BYTE;wOffset:WORD;bValue:BYTE); Stdcall;
function CAN_GetSystemFreq:Longword; Stdcall;

function CAN_InstallUserIsr(BoardNo:BYTE; Var UserIsr):Integer; Stdcall;
function CAN_RemoveUserIsr(BoardNo:BYTE):Integer; Stdcall;

implementation

function CAN_GetDllVersion;
         external 'PISOCAN.DLL' name 'CAN_GetDllVersion';
function CAN_TotalBoard;
         external 'PISOCAN.DLL' name 'CAN_TotalBoard';
function CAN_GetBoardInf;
         external 'PISOCAN.DLL' name 'CAN_GetCardInf';

function CAN_GetCardPortNum;
         external 'PISOCAN.DLL' name 'CAN_GetCardPortNum';

function CAN_ActiveBoard;
         external 'PISOCAN.DLL' name 'CAN_ActiveBoard';
function CAN_CloseBoard;
         external 'PISOCAN.DLL' name 'CAN_CloseBoard';
function CAN_BoardIsActive;
         external 'PISOCAN.DLL' name 'CAN_BoardIsActive';

function CAN_Reset;
         external 'PISOCAN.DLL' name 'CAN_Reset';
function CAN_Init;
         external 'PISOCAN.DLL' name 'CAN_Init';

function CAN_Config;
         external 'PISOCAN.DLL' name 'CAN_Config';
function CAN_ConfigWithoutStruct;
         external 'PISOCAN.DLL' name 'CAN_ConfigWithoutStruct;';

function CAN_EnableRxIrq;
         external 'PISOCAN.DLL' name 'CAN_EnableRxIrq';
function CAN_DisableRxIrq;
         external 'PISOCAN.DLL' name 'CAN_DisableRxIrq';
function CAN_RxIrqStatus;
         external 'PISOCAN.DLL' name 'CAN_RxIrqStatus';
function CAN_InstallIrq;
         external 'PISOCAN.DLL' name 'CAN_InstallIrq';
function CAN_RemoveIrq;
         external 'PISOCAN.DLL' name 'CAN_RemoveIrq';
function CAN_IrqStatus;
         external 'PISOCAN.DLL' name 'CAN_IrqStatus';
function CAN_Status;
         external 'PISOCAN.DLL' name 'CAN_Status';

function CAN_SendMsg;
         external 'PISOCAN.DLL' name 'CAN_SendMsg';
function CAN_SendWithoutStruct;
         external 'PISOCAN.DLL' name 'CAN_SendWithoutStruct';

function CAN_RxMsgCount;
         external 'PISOCAN.DLL' name 'CAN_RxMsgCount';
function CAN_ReceiveMsg;
         external 'PISOCAN.DLL' name 'CAN_ReceiveMsg';
function CAN_ReceiveWithoutStruct;
         external 'PISOCAN.DLL' name 'CAN_ReceiveWithoutStruct';

function CAN_ClearSoftBuffer;
         external 'PISOCAN.DLL' name 'CAN_ClearSoftBuffer';
function CAN_ClearDataOverrun;
         external 'PISOCAN.DLL' name 'CAN_ClearDataOverrun';
function CAN_IntputByte;
         external 'PISOCAN.DLL' name 'CAN_IntputByte';
procedure CAN_OutputByte;
         external 'PISOCAN.DLL' name 'CAN_OutputByte';

function CAN_GetSystemFreq;
         external 'PISOCAN.DLL' name 'CAN_GetSystemFreq';

function CAN_InstallUserIsr;
         external 'PISOCAN.DLL' name 'CAN_InstallUserIsr';
function CAN_RemoveUserIsr;
         external 'PISOCAN.DLL' name 'CAN_RemoveUserIsr';
end.

