unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls;

type
  TForm1 = class(TForm)
    btnExit: TButton;
    GroupBox1: TGroupBox;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    Label7: TLabel;
    Label8: TLabel;
    Label9: TLabel;
    Label10: TLabel;
    Label11: TLabel;
    lblTxS: TLabel;
    edtTXid: TEdit;
    edtTXrtr: TEdit;
    edtTXlen: TEdit;
    edtTXdata1: TEdit;
    edtTXdata2: TEdit;
    edtTXdata3: TEdit;
    edtTXdata4: TEdit;
    edtTXdata5: TEdit;
    edtTXdata6: TEdit;
    edtTXdata7: TEdit;
    edtTXdata8: TEdit;
    chk1: TCheckBox;
    edtTxS: TEdit;
    Button1: TButton;
    Timer1: TTimer;
    GroupBox2: TGroupBox;
    Label12: TLabel;
    Memo1: TMemo;
    edtRxS: TEdit;
    btnRX: TButton;
    procedure FormActivate(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure btnRXClick(Sender: TObject);
    procedure btnExitClick(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

uses PISOCAN;

var
  ret:Integer;
  SystemFreq:double;
  CanStruct:ConfigStruct;
  TxPacket,RxPacket:PacketStruct;
const
  P1 = 1;
  P2 = 2;
  Board = 0;
{$R *.DFM}

procedure TForm1.FormActivate(Sender: TObject);
var
  i:Integer;
  SystemHexFreq:LONGLONG;
begin
  ret := CAN_ActiveBoard(Board);
  if(ret <> 0) then
    Application.MessageBox('CAN_ActiveBoard Error!','Error',0+16);

  ret := CAN_Reset(Board,P1);
  if(ret <> 0) then
    Application.MessageBox('CAN_Reset Port 1 Error!','Error',0+16);

  ret := CAN_Reset(Board,P2);
  if(ret <> 0) then
    Application.MessageBox('CAN_Reset Port2 Error!','Error',0+16);

  for i:=0 to 3 do
    begin
      CanStruct.AccCode[i] := 0;
      CanStruct.AccMask[i] := $ff;
    end;

  CanStruct.BaudRate := 4; //4:125K bps

  ret := CAN_Init(Board,P1);
  if(ret <> 0) then
    Application.MessageBox('CAN_Init Port 1 Error!','Error',0+16);

  ret := CAN_Config(Board,P1,CanStruct);
  if(ret <> 0) then
    Application.MessageBox('CAN_Config Port 1 Error!','Error',0+16);

  ret := CAN_Init(Board,P2);
  if(ret <> 0) then
    Application.MessageBox('CAN_Init Port 2 Error!','Error',0+16);

  ret := CAN_Config(Board,P2,CanStruct);
  if(ret <> 0) then
    Application.MessageBox('CAN_Config Port 2 Error!','Error',0+16);

  ret := CAN_EnableRxIrq(Board,P2);
  if(ret <> 0) then
    Application.MessageBox('CAN_EnableRxIrq Port 2 Error!','Error',0+16);

  ret := CAN_InstallIrq(Board);
  if(ret <> 0) then
    Application.MessageBox('CAN_InstallIrqError!','Error',0+16);

  SystemHexFreq := CAN_GetSystemFreq();
  if (SystemHexFreq=0) then SystemHexFreq := 1;

  SystemFreq := SystemHexFreq;
end;

procedure TForm1.Button1Click(Sender: TObject);
begin
  TxPacket.mode := 0;
  TxPacket.id := StrToInt('0x' + edtTXid.Text);
  TxPacket.rtr := BYTE(StrToInt(edtTXrtr.Text));
  TxPacket.len := BYTE(StrToInt(edtTXlen.Text));
  if(chk1.Checked) then TxPacket.mode := 1;
  TxPacket.data[0] := BYTE(StrToInt('0x'+ edtTXdata1.Text));
  TxPacket.data[1] := BYTE(StrToInt('0x'+ edtTXdata2.Text));
  TxPacket.data[2] := BYTE(StrToInt('0x'+ edtTXdata3.Text));
  TxPacket.data[3] := BYTE(StrToInt('0x'+ edtTXdata4.Text));
  TxPacket.data[4] := BYTE(StrToInt('0x'+ edtTXdata5.Text));
  TxPacket.data[5] := BYTE(StrToInt('0x'+ edtTXdata6.Text));
  TxPacket.data[6] := BYTE(StrToInt('0x'+ edtTXdata7.Text));
  TxPacket.data[7] := BYTE(StrToInt('0x'+ edtTXdata8.Text));

  ret := CAN_SendMsg(Board,P1,TxPacket);
  if(ret <> 0) then
    Application.MessageBox('CAN_SendMsg Error!','Error',0+16);

end;

procedure TForm1.btnRXClick(Sender: TObject);
var
  i,j,k:Integer;
  idl:Integer;
  ReceiveTimeStamp:double;
  tmp:AnsiString;
begin
 Memo1.Clear();

 i := CAN_RxMsgCount(Board,P2);
 if(i=0) then exit;
 for j:=0 to i-1 do
   begin
   ret := CAN_ReceiveMsg(Board,P2,RxPacket);
   if(ret <> 0) then
     begin
        Application.MessageBox('CAN_Receive Error!','Error',0+16);
        exit;
     end;

   if(RxPacket.mode <> 0) then idl := 8
   else idl := 3;

   tmp := IntToStr(j+1)+'  Mode:' + IntToStr(RxPacket.mode) + '  ID:'
       + IntToHex(RxPacket.id,idl)+ 'h  RTR:' + IntToStr(RxPacket.rtr)
       + '  DLC:'+ IntToStr(RxPacket.len) + '  DATA(hex): ';

   for k:=0 to RxPacket.len-1 do
     begin
        tmp := tmp + IntToHex(RxPacket.data[k],2)+ ' ';
     end;

   ReceiveTimeStamp := RxPacket.MsgTimeStamps;
   tmp := tmp + '  TimeStamp=' + FloatToStr(ReceiveTimeStamp/SystemFreq) + ' (sec)';
   Memo1.Lines.Add(tmp);
   end;
end;

procedure TForm1.btnExitClick(Sender: TObject);
begin
   ret := CAN_RemoveIrq(Board);
   if(ret <> 0) then
     Application.MessageBox('CAN_RemoveIrq Error!','Error',0+16);
     
   ret := CAN_CloseBoard(Board);
   Close();
end;

procedure TForm1.Timer1Timer(Sender: TObject);
var
   bStatus:BYTE;
begin
   ret := CAN_Status(Board,P1,bStatus);
   if(ret = 0) then edtTxS.Text := IntToHex(bStatus,2);
   ret := CAN_Status(Board,P2,bStatus);
   if(ret = 0) then edtRxS.Text := IntToHex(bStatus,2);
end;

end.
