// demo2Dlg.cpp : implementation file

#include "stdafx.h"
#include "demo2.h"
#include "demo2Dlg.h"

#include "can.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
ConfigStruct CanConfig;
PacketStruct CANTx,CANRx;
double SystemFreq;
int ret;
BYTE B0 = 0;
BYTE P1 = 1,P2 = 2;
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CDemo2Dlg dialog

CDemo2Dlg::CDemo2Dlg(CWnd* pParent /*=NULL*/)
	: CDialog(CDemo2Dlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CDemo2Dlg)
	m_lblStatus1 = _T("");
	m_lblStatus2 = _T("");
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CDemo2Dlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CDemo2Dlg)
	DDX_Control(pDX, IDC_LIST1, m_listbox);
	DDX_Control(pDX, IDC_EDIT11, m_txtTxdata7);
	DDX_Control(pDX, IDC_EDIT10, m_txtTxdata6);
	DDX_Control(pDX, IDC_EDIT9, m_txtTxdata5);
	DDX_Control(pDX, IDC_EDIT8, m_txtTxdata4);
	DDX_Control(pDX, IDC_EDIT7, m_txtTxdata3);
	DDX_Control(pDX, IDC_EDIT6, m_txtTxdata2);
	DDX_Control(pDX, IDC_EDIT5, m_txtTxdata1);
	DDX_Control(pDX, IDC_EDIT4, m_txtTxdata0);
	DDX_Control(pDX, IDC_EDIT3, m_txtTxlen);
	DDX_Control(pDX, IDC_EDIT2, m_txtTxrtr);
	DDX_Control(pDX, IDC_EDIT1, m_txtTxid);
	DDX_Control(pDX, IDC_CHECK1, m_Check1);
	DDX_Text(pDX, IDC_STATIC_STATUS1, m_lblStatus1);
	DDX_Text(pDX, IDC_STATIC_STATUS2, m_lblStatus2);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CDemo2Dlg, CDialog)
	//{{AFX_MSG_MAP(CDemo2Dlg)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_WM_DESTROY()
	ON_WM_TIMER()
	ON_BN_CLICKED(IDC_BUTTON3, OnClearOverrun)
	ON_BN_CLICKED(IDC_BUTTON1, OnSend)
	ON_BN_CLICKED(IDC_BUTTON2, OnReceive)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CDemo2Dlg message handlers

BOOL CDemo2Dlg::OnInitDialog()
{
	int i;

	CDialog::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// TODO: Add extra initialization here
	ret = CAN_ActiveBoard(B0);
	if(ret){
		CString ErrBuf;

		ErrBuf.Format(_T("CAN_ActiveBoard error!  Code:%d"),ret);
		MessageBox(ErrBuf,NULL,NULL);
		OnCancel();
	}

	ret = CAN_Reset(B0,P1);
	if(ret){
		CString ErrBuf;

		ErrBuf.Format(_T("CAN_Reset Port 1 error!  Code:%d"),ret);
		MessageBox(ErrBuf,NULL,NULL);
		OnCancel();
	}

	ret = CAN_Reset(B0,P2);
	if(ret){
		CString ErrBuf;

		ErrBuf.Format(_T("CAN_Reset Port 2 error!  Code:%d"),ret);
		MessageBox(ErrBuf,NULL,NULL);
		OnCancel();
	}

	ret = CAN_Init(B0,P1);
	if(ret){
		CString ErrBuf;

		ErrBuf.Format(_T("CAN_Init Port 1 error!  Code:%d"),ret);
		MessageBox(ErrBuf,NULL,NULL);
		OnCancel();
	}

	for(i=0;i<=3;i++){
		CanConfig.AccCode[i] = 0;
		CanConfig.AccMask[i] = 0xff;
	}
	CanConfig.BaudRate = 4;  //4:125Kbps

	ret = CAN_Config(B0,P1,&CanConfig);
	if(ret){
		CString ErrBuf;

		ErrBuf.Format(_T("CAN_Config Port 1 error!  Code:%d"),ret);
		MessageBox(ErrBuf,NULL,NULL);
		OnCancel();
	}

	ret = CAN_Init(B0,P2);
	if(ret){
		CString ErrBuf;

		ErrBuf.Format(_T("CAN_Init Port 2 error!  Code:%d"),ret);
		MessageBox(ErrBuf,NULL,NULL);
		OnCancel();
	}

	ret = CAN_Config(B0,P2,&CanConfig);
	if(ret){
		CString ErrBuf;

		ErrBuf.Format(_T("CAN_Config Port 2 error!  Code:%d"),ret);
		MessageBox(ErrBuf,NULL,NULL);
		OnCancel();
	}

	ret = CAN_EnableRxIrq(B0,P2);
	if(ret){
		CString ErrBuf;

		ErrBuf.Format(_T("CAN_EnableRxIrq Port 2 error!  Code:%d"),ret);
		MessageBox(ErrBuf,NULL,NULL);
		OnCancel();
	}

	ret = CAN_InstallIrq(B0);
	if(ret){
		CString ErrBuf;

		ErrBuf.Format(_T("CAN_InstallIrq error!  Code:%d"),ret);
		MessageBox(ErrBuf,NULL,NULL);
		OnCancel();
	}

	SystemFreq =(double)CAN_GetSystemFreq();

	if (SystemFreq == 0){
		MessageBox("Get SystemFreq error!",NULL,NULL);
		SystemFreq = 1; //avoid to divide zero
	}

	m_txtTxid.SetWindowText("123");
	m_txtTxrtr.SetWindowText("0");
	m_txtTxlen.SetWindowText("8");
	m_txtTxdata0.SetWindowText("11");
	m_txtTxdata1.SetWindowText("22");
	m_txtTxdata2.SetWindowText("33");
	m_txtTxdata3.SetWindowText("44");
	m_txtTxdata4.SetWindowText("55");
	m_txtTxdata5.SetWindowText("66");
	m_txtTxdata6.SetWindowText("77");
	m_txtTxdata7.SetWindowText("88");

	SetTimer(1,500,NULL);
	
	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CDemo2Dlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CDemo2Dlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CDemo2Dlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CDemo2Dlg::OnCancel() 
{
	// TODO: Add extra cleanup here

	CDialog::OnCancel();
}

void CDemo2Dlg::OnDestroy() 
{
	CDialog::OnDestroy();
	
	// TODO: Add your message handler code here
	KillTimer(1);

	ret = CAN_RemoveIrq(B0);
	if(ret){
		CString ErrBuf;

		ErrBuf.Format(_T("CAN_RemoveIrq error!  Code:%d"),ret);
		MessageBox(ErrBuf,NULL,NULL);
	}
	ret = CAN_CloseBoard(B0);
}

void CDemo2Dlg::OnClearOverrun() // Clear Data Overrun
{
	// TODO: Add your control notification handler code here
	ret = CAN_ClearDataOverrun(B0, P2);
	if(ret){
		CString ErrBuf;

		ErrBuf.Format(_T("CAN_ClearDataOverrun Port 2 error!  Code:%d"),ret);
		MessageBox(ErrBuf,NULL,NULL);
	}
}

void CDemo2Dlg::OnSend()  // Send CAN Message
{
	char TempTxBuf[20];
	char *endptr;
	// TODO: Add your control notification handler code here
	if (m_Check1.GetCheck() == 1){
		CANTx.mode = 1;
	}
	else{
		CANTx.mode = 0;
	}
  
	m_txtTxid.GetWindowText(TempTxBuf,20);
	CANTx.id = strtoul(TempTxBuf,&endptr,16);
	if (CANTx.id > 0x1FFFFFFF){
		MessageBox(_T("ID  error!"),NULL,NULL);
		return;
	}
	m_txtTxrtr.GetWindowText(TempTxBuf,20);
	CANTx.rtr = (BYTE)strtol(TempTxBuf,&endptr,16);
	m_txtTxlen.GetWindowText(TempTxBuf,20);
	CANTx.len = (BYTE)strtol(TempTxBuf,&endptr,16);
  
	m_txtTxdata0.GetWindowText(TempTxBuf,20);
	CANTx.data[0] = (BYTE)strtol(TempTxBuf,&endptr,16);
	m_txtTxdata1.GetWindowText(TempTxBuf,20);
	CANTx.data[1] = (BYTE)strtol(TempTxBuf,&endptr,16);
	m_txtTxdata2.GetWindowText(TempTxBuf,20);
	CANTx.data[2] = (BYTE)strtol(TempTxBuf,&endptr,16);
	m_txtTxdata3.GetWindowText(TempTxBuf,20);
	CANTx.data[3] = (BYTE)strtol(TempTxBuf,&endptr,16);
	m_txtTxdata4.GetWindowText(TempTxBuf,20);
	CANTx.data[4] = (BYTE)strtol(TempTxBuf,&endptr,16);
	m_txtTxdata5.GetWindowText(TempTxBuf,20);
	CANTx.data[5] = (BYTE)strtol(TempTxBuf,&endptr,16);
	m_txtTxdata6.GetWindowText(TempTxBuf,20);
	CANTx.data[6] = (BYTE)strtol(TempTxBuf,&endptr,16);
	m_txtTxdata7.GetWindowText(TempTxBuf,20);
	CANTx.data[7] = (BYTE)strtol(TempTxBuf,&endptr,16);
  
	ret = CAN_SendMsg(B0, P1, &CANTx);
	if(ret){
		CString ErrBuf;

		ErrBuf.Format(_T("CAN_SendMsg error!  Code:%d"),ret);
		MessageBox(ErrBuf,NULL,NULL);
	}
}

void CDemo2Dlg::OnReceive() // Reveice CAN Message
{
	int i,j;
	char Temp[200];
	double ReceiveTimeStamp;
	// TODO: Add your control notification handler code here
	j = m_listbox.GetCount();
	for(i=0;i<j;i++){
		m_listbox.DeleteString(0);
	}

	i = CAN_RxMsgCount(B0, P2);
    if (i == 0) return;

	for(j=0;j<i;j++){
		ret = CAN_ReceiveMsg(B0, P2, &CANRx);
		if(ret){
			CString ErrBuf;

			ErrBuf.Format(_T("CAN_ReceiveMsg error!  Code:%d"),ret);
			MessageBox(ErrBuf,NULL,NULL);
		}

		ReceiveTimeStamp = (double)CANRx.MsgTimeStamps;

		sprintf(Temp,"%02d  Mode:%d  ID:%X  RTR:%d  DLC:%d  Data(hex):%02X %02X %02X %02X %02X %02X %02X %02X  TimeStamp=%f",			
			j,CANRx.mode,CANRx.id,CANRx.rtr,CANRx.len,CANRx.data[0],CANRx.data[1],
			CANRx.data[2],CANRx.data[3],CANRx.data[4],CANRx.data[5],CANRx.data[6],
			CANRx.data[7],ReceiveTimeStamp/SystemFreq);

		m_listbox.AddString(Temp);
	}
}

void CDemo2Dlg::OnTimer(UINT nIDEvent) // Check CAN Status
{
	BYTE status;
	// TODO: Add your message handler code here and/or call default
	
	ret = CAN_Status(B0, P1, &status);
	if (ret == 0){
		m_lblStatus1.Format(_T("%X"),status);
	}
	else{
		m_lblStatus1.Format(_T(""));
	}

	status = 0;

	ret = CAN_Status(B0, P2, &status);
	if (ret == 0){
		m_lblStatus2.Format(_T("%X"),status);
	}
	else{
		m_lblStatus2.Format(_T(""));
	}

	UpdateData(FALSE);
	CDialog::OnTimer(nIDEvent);
}


