﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using PISOCAN_Net;

namespace demo2
{
    public partial class Form1 : Form
    {
        const byte B0 = 0;  // PISO-CAN Board Number = 0
        const byte P1 = 1;  // CAN Port 1
        const byte P2 = 2;  // CNA Port 2

        ulong SystemFreq;

        public Form1()
        {
            InitializeComponent();
        }

        private void Form1_Load(object sender, EventArgs e)
        {
            ushort ret;


            ret = PISOCAN.CAN_ActiveBoard(B0);
            if (ret != 0)
            {
                MessageBox.Show("CAN_ActiveBoard error!  Code: " + ret.ToString());
                this.Close();
            }

            ret = PISOCAN.CAN_Reset(B0, P1);
            if (ret != 0)
            {
                MessageBox.Show("CAN_Reset Port 1 error!  Code: " + ret.ToString());
                this.Close();
            }

            ret = PISOCAN.CAN_Reset(B0, P2);
            if (ret != 0)
            {
                MessageBox.Show("CAN_Reset Port 2 error!  Code: " + ret.ToString());
                this.Close();
            }

            ret = PISOCAN.CAN_Init(B0, P1);
            if (ret != 0)
            {
                MessageBox.Show("CAN_Init Port 1 error!  Code: " + ret.ToString());
                this.Close();
            }

            ret = PISOCAN.CAN_ConfigWithoutStruct(B0, P1, 0x00000000, 0xFFFFFFFF, PISOCAN.BaudRate._4_CAN_125K, 0, 0);
            if (ret != 0)
            {
                MessageBox.Show("CAN_Config Port 1 error!  Code: " + ret.ToString());
                this.Close();
            }

            ret = PISOCAN.CAN_Init(B0, P2);
            if (ret != 0)
            {
                MessageBox.Show("CAN_Init Port 2 error!  Code: " + ret.ToString());
                this.Close();
            }

            ret = PISOCAN.CAN_ConfigWithoutStruct(B0, P2, 0x00000000, 0xFFFFFFFF, PISOCAN.BaudRate._4_CAN_125K, 0, 0);
            if (ret != 0)
            {
                MessageBox.Show("CAN_Config Port 2 error!  Code: " + ret.ToString());
                this.Close();
            }

            ret = PISOCAN.CAN_EnableRxIrq(B0, P2);
            if (ret != 0)
            {
                MessageBox.Show("CAN_EnableRxIrq Port 2 error!  Code: " + ret.ToString());
                this.Close();
            }

            ret = PISOCAN.CAN_InstallIrq(B0);
            if (ret != 0)
            {
                MessageBox.Show("CAN_InstallIrq error!  Code: " + ret.ToString());
                this.Close();
            }

            SystemFreq = PISOCAN.CAN_GetSystemFreq();

            if (SystemFreq == 0)
            {
                MessageBox.Show("Get SystemFreq error!");
                SystemFreq = 1; //avoid to divide zero
                this.Close();
            }

            timer1.Enabled = true;
        }

        private void Form1_FormClosed(object sender, FormClosedEventArgs e)
        {
            timer1.Enabled = false;

            PISOCAN.CAN_CloseBoard(B0);
        }

        private void Btn_Exit_Click(object sender, EventArgs e)
        {
            this.Close();
        }

        private void Check_29_CheckedChanged(object sender, EventArgs e)
        {
            if (Check_29.Checked) Text_ID.MaxLength = 8;
            else Text_ID.MaxLength = 3;
        }

        private void Btn_ClearOverrun_Click(object sender, EventArgs e)
        {
            ushort ret;

            ret = PISOCAN.CAN_ClearDataOverrun(B0, P2);
            if (ret != 0)
            {
                MessageBox.Show("CAN_ClearDataOverrun Port 2 error!  Code: " + ret.ToString());
            }
        }

        private void Check_Is_Dec(object sender, KeyPressEventArgs e)
        {
            if (!(("1234567890".IndexOf(e.KeyChar) != -1) || ((int)e.KeyChar == 8))) e.Handled = true;
        }

        private void Check_Is_Hex(object sender, KeyPressEventArgs e)
        {
            if (!(("1234567890ABCDEFabcdef".IndexOf(e.KeyChar) != -1) || ((int)e.KeyChar == 8))) e.Handled = true;
        }

        private void Btn_Send_Click(object sender, EventArgs e)
        {
            ushort ret;
            uint ID;
            byte Mode;
            byte Rtr;
            byte Dlc;
            byte[] Data = new byte[8];
            TextBox[] TextData = new TextBox[8] { Text_D0, Text_D1, Text_D2, Text_D3, Text_D4, Text_D5, Text_D6, Text_D7 };

            ID = Convert.ToUInt32(Text_ID.Text, 16);
            Mode = Convert.ToByte(Check_29.Checked);
            Rtr = Convert.ToByte(Text_Rtr.Text);
            Dlc = Convert.ToByte(Text_Len.Text);

            for (int i = 0; i < 8; i++)
            {
                Data[i] = Convert.ToByte(TextData[i].Text, 16);
            }

            ret = PISOCAN.CAN_SendWithoutStruct(B0, P1, Mode, ID, Rtr, Dlc, Data);
            if (ret != 0)
            {
                MessageBox.Show("CAN_SendMsg error!  Code: " + ret.ToString());
            }
        }

        private void Btn_Receive_Click(object sender, EventArgs e)
        {
            ushort ret, Cnt;
            uint ID;
            byte Mode;
            byte Rtr;
            byte Dlc;
            byte[] Data = new byte[8];
            uint H_Time, L_Time;
            ulong TimeStamp;
            string DataStr;

            List_Receive.Items.Clear();

            Cnt = PISOCAN.CAN_RxMsgCount(B0, P2);
            if (Cnt == 0) return;

            for (ushort j = 0; j < Cnt; j++)
            {
                ret = PISOCAN.CAN_ReceiveWithoutStruct(B0, P2, out Mode, out ID, out Rtr, out Dlc, Data, out H_Time, out L_Time);
                if (ret != 0)
                {
                    MessageBox.Show("CAN_ReceiveMsg error!  Code: " + ret.ToString());
                    break;
                }

                TimeStamp = H_Time;
                TimeStamp = ((TimeStamp << 32) & 0xFFFFFFFF00000000) + L_Time;

                DataStr = j.ToString() + "  Mode:" + Mode.ToString() + "  ID:" + ID.ToString("X" + Text_ID.MaxLength.ToString()) + "  RTR:" + Rtr.ToString() + "  DLC:" + Dlc.ToString() + "  Data(hex): ";
                for (ushort k = 0; k < Dlc; k++)
                {
                    DataStr = DataStr + Data[k].ToString("X2") + " ";
                }
                DataStr = DataStr + "TimeStamp = " + ((double)TimeStamp / (double)SystemFreq).ToString("f6");

                List_Receive.Items.Add(DataStr);
            }
        }

        private void timer1_Tick(object sender, EventArgs e)
        {
            ushort ret;
            byte status;

            ret = PISOCAN.CAN_Status(B0, P1, out status);
            if (ret == 0)
            {
                Text_Status1.Text = status.ToString("X");
            }
            else
            {
                Text_Status1.Text = "";
            }

            status = 0;

            ret = PISOCAN.CAN_Status(B0, P2, out status);
            if (ret == 0)
            {
                Text_Status2.Text = status.ToString("X");
            }
            else
            {
                Text_Status2.Text = "";
            }
        }
    }
}