Imports PISOCAN_Net

Public Class Form1

    Public Const B0 As Byte = 0  ' PISO-CAN Board Number = 0
    Public Const P1 As Byte = 1  ' CAN Port 1
    Public Const P2 As Byte = 2  ' CNA Port 2

    Dim SystemFreq As ULong

    Private Sub Form1_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
        Dim ret As UShort

        ret = PISOCAN.CAN_ActiveBoard(B0)
        If (ret <> 0) Then
            MessageBox.Show("CAN_ActiveBoard error!  Code: " + ret.ToString())
            Close()
        End If

        ret = PISOCAN.CAN_Reset(B0, P1)
        If (ret <> 0) Then
            MessageBox.Show("CAN_Reset Port 1 error!  Code: " + ret.ToString())
            Close()
        End If

        'ret = PISOCAN.CAN_Reset(B0, P2)
        'If (ret <> 0) Then
        '    MessageBox.Show("CAN_Reset Port 2 error!  Code: " + ret.ToString())
        '    Close()
        'End If

        ret = PISOCAN.CAN_Init(B0, P1)
        If (ret <> 0) Then
            MessageBox.Show("CAN_Init Port 1 error!  Code: " + ret.ToString())
            Close()
        End If

        ret = PISOCAN.CAN_ConfigWithoutStruct(B0, P1, &H0, &HFFFFFFFFUI, PISOCAN.BaudRate._4_CAN_125K, 0, 0)
        If (ret <> 0) Then
            MessageBox.Show("CAN_Config Port 1 error!  Code: " + ret.ToString())
            Close()
        End If

        'ret = PISOCAN.CAN_Init(B0, P2)
        'If (ret <> 0) Then
        '    MessageBox.Show("CAN_Init Port 2 error!  Code: " + ret.ToString())
        '    Close()
        'End If

        'ret = PISOCAN.CAN_ConfigWithoutStruct(B0, P2, &H0, &HFFFFFFFFUI, PISOCAN.BaudRate._4_CAN_125K, 0, 0)
        'If (ret <> 0) Then
        '    MessageBox.Show("CAN_Config Port 2 error!  Code: " + ret.ToString())
        '    Close()
        'End If

        'ret = PISOCAN.CAN_EnableRxIrq(B0, P2)
        'If (ret <> 0) Then
        '    MessageBox.Show("CAN_EnableRxIrq Port 2 error!  Code: " + ret.ToString())
        '    Close()
        'End If

        ret = PISOCAN.CAN_InstallIrq(B0)
        If (ret <> 0) Then
            MessageBox.Show("CAN_InstallIrq error!  Code: " + ret.ToString())
            Close()
        End If

        SystemFreq = PISOCAN.CAN_GetSystemFreq()

        If (SystemFreq = 0) Then
            MessageBox.Show("Get SystemFreq error!")
            SystemFreq = 1  'avoid to divide zero
            Close()
        End If

        timer1.Enabled = True
    End Sub

    Private Sub Form1_FormClosed(ByVal sender As System.Object, ByVal e As System.Windows.Forms.FormClosedEventArgs) Handles MyBase.FormClosed
        timer1.Enabled = False

        PISOCAN.CAN_CloseBoard(B0)
    End Sub

    Private Sub Btn_Exit_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Btn_Exit.Click
        Close()
    End Sub

    Private Sub Check_29_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Check_29.CheckedChanged
        If (Check_29.Checked) Then
            Text_ID.MaxLength = 8
        Else
            Text_ID.MaxLength = 3
        End If
    End Sub

    Private Sub Btn_ClearOverrun_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Btn_ClearOverrun.Click
        Dim ret As UShort

        'ret = PISOCAN.CAN_ClearDataOverrun(B0, P2)
        'If (ret <> 0) Then
        '    MessageBox.Show("CAN_ClearDataOverrun Port 2 error!  Code: " + ret.ToString())
        'End If
    End Sub

    Private Sub Check_Is_Dec(ByVal sender As System.Object, ByVal e As System.Windows.Forms.KeyPressEventArgs) Handles Text_Rtr.KeyPress, Text_Len.KeyPress
        If ((("1234567890".IndexOf(e.KeyChar) <> -1) Or (Convert.ToInt16(e.KeyChar) = 8)) = False) Then e.Handled = True
    End Sub

    Private Sub Check_Is_Hex(ByVal sender As System.Object, ByVal e As System.Windows.Forms.KeyPressEventArgs) Handles Text_ID.KeyPress, Text_D7.KeyPress, Text_D6.KeyPress, Text_D5.KeyPress, Text_D4.KeyPress, Text_D3.KeyPress, Text_D2.KeyPress, Text_D1.KeyPress, Text_D0.KeyPress
        If ((("1234567890ABCDEFabcdef".IndexOf(e.KeyChar) <> -1) Or (Convert.ToInt16(e.KeyChar) = 8)) = False) Then e.Handled = True
    End Sub

    Private Sub Btn_Send_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Btn_Send.Click
        Dim ret As UShort
        Dim ID As UInt32
        Dim Mode As Byte
        Dim Rtr As Byte
        Dim Dlc As Byte
        Dim Data(8) As Byte
        Dim TextData() As TextBox = {Text_D0, Text_D1, Text_D2, Text_D3, Text_D4, Text_D5, Text_D6, Text_D7}

        Dim i As Int32

        ID = Convert.ToUInt32(Text_ID.Text, 16)
        Mode = Convert.ToByte(Check_29.Checked)
        Rtr = Convert.ToByte(Text_Rtr.Text)
        Dlc = Convert.ToByte(Text_Len.Text)

        For i = 0 To 7
            Data(i) = Convert.ToByte(TextData(i).Text, 16)
        Next

        ret = PISOCAN.CAN_SendWithoutStruct(B0, P1, Mode, ID, Rtr, Dlc, Data)
        If (ret <> 0) Then
            MessageBox.Show("CAN_SendMsg error!  Code: " + ret.ToString())
        End If
    End Sub

    Private Sub Btn_Receive_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Btn_Receive.Click
        Dim ret As UShort, Cnt As UShort
        Dim ID As UInt32
        Dim Mode As Byte
        Dim Rtr As Byte
        Dim Dlc As Byte
        Dim Data(8) As Byte
        Dim H_Time As UInt32, L_Time As UInt32
        Dim TimeStamp As ULong
        Dim DataStr As String

        'Dim j As UShort, k As UShort

        'List_Receive.Items.Clear()

        'Cnt = PISOCAN.CAN_RxMsgCount(B0, P2)
        'If (Cnt = 0) Then Return

        'For j = 0 To (Cnt - 1)

        '    ret = PISOCAN.CAN_ReceiveWithoutStruct(B0, P2, Mode, ID, Rtr, Dlc, Data, H_Time, L_Time)
        '    If (ret <> 0) Then
        '        MessageBox.Show("CAN_ReceiveMsg error!  Code: " + ret.ToString())
        '        Exit For
        '    End If

        '    TimeStamp = H_Time
        '    TimeStamp = ((TimeStamp << 32) And &HFFFFFFFF00000000UL) + L_Time

        '    DataStr = j.ToString() + "  Mode:" + Mode.ToString() + "  ID:" + ID.ToString("X" + Text_ID.MaxLength.ToString()) + "  RTR:" + Rtr.ToString() + "  DLC:" + Dlc.ToString() + "  Data(hex): "
        '    For k = 0 To (Dlc - 1)
        '        DataStr = DataStr + Data(k).ToString("X2") + " "
        '    Next
        '    DataStr = DataStr + "TimeStamp = " + (Convert.ToDouble(TimeStamp) / Convert.ToDouble(SystemFreq)).ToString("f6")

        '    List_Receive.Items.Add(DataStr)
        'Next
    End Sub

    Private Sub timer1_Tick(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles timer1.Tick
        Dim ret As UShort
        Dim status As Byte

        ret = PISOCAN.CAN_Status(B0, P1, status)
        If (ret = 0) Then
            Text_Status1.Text = status.ToString("X")
        Else
            Text_Status1.Text = ""
        End If

        status = 0

        ret = PISOCAN.CAN_Status(B0, P2, status)
        If (ret = 0) Then
            Text_Status2.Text = status.ToString("X")
        Else
            Text_Status2.Text = ""
        End If
    End Sub
End Class
