
// The following ifdef block is the standard way of creating macros which make exporting 
// from a DLL simpler. All files within this DLL are compiled with the PISOCAN_EXPORTS
// symbol defined on the command line. this symbol should not be defined on any project
// that uses this DLL. This way any other project whose source files include this file see 
// PISOCAN_API functions as being imported from a DLL, wheras this DLL sees symbols
// defined with this macro as being exported.
#ifdef PISOCAN_EXPORTS
#define PISOCAN_API extern "C" __declspec(dllexport)
#else
#define PISOCAN_API extern "C" __declspec(dllimport)
#endif

// This class is exported from the PISOCAN.dll

#define CAN_NoError                    0
#define CAN_DriverError                1
#define CAN_ActiveBoardError           2
#define CAN_BoardNumberError           3
#define CAN_PortNumberError            4 
#define CAN_ResetError                 5
#define CAN_SoftResetError             6
#define CAN_InitError                  7       
#define CAN_ConfigError                8
#define CAN_SetACRError                9
#define CAN_SetAMRError                10
#define CAN_SetBaudRateError           11

#define CAN_TransmitBufferLocked       16
#define CAN_TransmitIncomplete         17
#define CAN_ReceiveBufferEmpty         18
#define CAN_DataOverrun                19
#define CAN_ReceiveError               20
#define CAN_SoftBufferIsEmpty          21
#define CAN_SoftBufferIsFull           22
#define CAN_TimeOut                    23
#define CAN_InstallIsrError			   24

typedef struct {
	unsigned char Mode;  // 0: id ׬ 11 bits
	                     // 1: id ׬ 29 bits
	                     
	unsigned char RTR;   // 0 or 1 user defined
	unsigned char id[4];
	unsigned char len;
	unsigned char data[8];
} PacketStruct;

typedef struct {
	
	BYTE BaudRate;
	BYTE AccCode[4];  
	BYTE AccMask[4];      
	//BYTE BT0;
	//BYTE BT1;
	
}ConfigStruct;

#define CBR_125K	1
#define CBR_250K	2
#define CBR_500K	3
#define CBR_800K	4
#define CBR_1M		5

PISOCAN_API WORD CAN_GetDllVersion(void);
PISOCAN_API int CAN_TotalBoard(void);
PISOCAN_API int CAN_Init(BYTE BoardNo, BYTE Port);
PISOCAN_API int CAN_Reset(BYTE BoardNo,BYTE Port);
PISOCAN_API int CAN_Config(BYTE BoardNo, BYTE Port,ConfigStruct *CANConfig);
PISOCAN_API int CAN_SendMsg(BYTE BoardNo, BYTE Port,PacketStruct *CanPacket);
PISOCAN_API int CAN_ReceiveMsg(BYTE BoardNo, BYTE Port,PacketStruct *CanPacket);
PISOCAN_API int CAN_ConfigWithoutStructure(BYTE BoardNo, BYTE Port,DWORD AccCode, DWORD AccMask, BYTE BaudRate);
PISOCAN_API int CAN_SendMsgWithOutStruct(BYTE BoardNo, BYTE Port,BYTE Mode,ULONG Id,BYTE Rtr,BYTE Dlen,BYTE *Data);
PISOCAN_API int CAN_ReceiveMsgWithOutStruct(BYTE BoardNo, BYTE Port,BYTE *Mode,ULONG *Id,BYTE *Rtr,BYTE *Dlen,BYTE *Data);