// PCI_104_CE_TestDlg.cpp : implementation file
//

#include "stdafx.h"
#include "PCI_104_CE_Test.h"
#include "PCI_104_CE_TestDlg.h"
#include "PISOCAN.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CPCI_104_CE_TestDlg dialog
PacketStruct CanPacket;
int iRet;
unsigned long lCounter=0;
TCHAR wTemp[20];
char cTemp[20];
unsigned long ID;
unsigned char Data; 
BYTE iPort,iBoard;


CPCI_104_CE_TestDlg::CPCI_104_CE_TestDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CPCI_104_CE_TestDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CPCI_104_CE_TestDlg)
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CPCI_104_CE_TestDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CPCI_104_CE_TestDlg)
	DDX_Control(pDX, IDC_AM3, m_AM3);
	DDX_Control(pDX, IDC_AM2, m_AM2);
	DDX_Control(pDX, IDC_AM1, m_AM1);
	DDX_Control(pDX, IDC_AM0, m_AM0);
	DDX_Control(pDX, IDC_AC3, m_AC3);
	DDX_Control(pDX, IDC_AC2, m_AC2);
	DDX_Control(pDX, IDC_AC1, m_AC1);
	DDX_Control(pDX, IDC_AC0, m_AC0);
	DDX_Control(pDX, IDC_Receive, m_Receive);
	DDX_Control(pDX, IDC_Board, m_Board);
	DDX_Control(pDX, IDC_RTR, m_RTR);
	DDX_Control(pDX, IDC_Mode, m_Mode);
	DDX_Control(pDX, IDC_Len, m_Len);
	DDX_Control(pDX, IDC_ID, m_ID);
	DDX_Control(pDX, IDC_D7, m_D7);
	DDX_Control(pDX, IDC_D6, m_D6);
	DDX_Control(pDX, IDC_D5, m_D5);
	DDX_Control(pDX, IDC_D4, m_D4);
	DDX_Control(pDX, IDC_D3, m_D3);
	DDX_Control(pDX, IDC_D2, m_D2);
	DDX_Control(pDX, IDC_D1, m_D1);
	DDX_Control(pDX, IDC_D0, m_D0);
	DDX_Control(pDX, IDC_BaudRate, m_BaudRate);
	DDX_Control(pDX, IDC_Port, m_Port);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CPCI_104_CE_TestDlg, CDialog)
	//{{AFX_MSG_MAP(CPCI_104_CE_TestDlg)
	ON_BN_CLICKED(IDC_BUTTON3, OnOpenCANPort)
	ON_BN_CLICKED(IDC_ClosePort, OnClosePort)
	ON_BN_CLICKED(IDC_Send, OnSend)
	ON_BN_CLICKED(IDC_Recv, OnRecv)
	ON_WM_TIMER()
	ON_BN_CLICKED(IDC_Stop, OnStop)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CPCI_104_CE_TestDlg message handlers

BOOL CPCI_104_CE_TestDlg::OnInitDialog()
{
	
	CDialog::OnInitDialog();
	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	
	CenterWindow(GetDesktopWindow());	// center to the hpc screen
	m_Board.SetWindowText(L"0");
	m_Port.SetWindowText(L"2");
	m_BaudRate.SetCurSel(0);
	m_AM0.SetWindowText(L"FF");
	m_AM1.SetWindowText(L"FF");
	m_AM2.SetWindowText(L"FF");
	m_AM3.SetWindowText(L"FF");
	m_AC0.SetWindowText(L"0");
	m_AC1.SetWindowText(L"0");
	m_AC2.SetWindowText(L"0");
	m_AC3.SetWindowText(L"0");

	m_Receive.InsertColumn(0,L"NO",LVCFMT_CENTER,40);
	m_Receive.InsertColumn(1,L"MOD",LVCFMT_CENTER,40);
	m_Receive.InsertColumn(2,L"ID(Hex)",LVCFMT_CENTER,60);
	m_Receive.InsertColumn(3,L"RTR",LVCFMT_CENTER,40);
	m_Receive.InsertColumn(4,L"DLC",LVCFMT_CENTER,40);

	for(int i=0;i<8; i++){
		wsprintf(wTemp,TEXT("D%d"),i);
		m_Receive.InsertColumn(i+5,wTemp,LVCFMT_CENTER,30);}
	
	m_Receive.SetExtendedStyle(LVS_EX_GRIDLINES | LVS_EX_FULLROWSELECT);

	UpdateData(false);
	
	// TODO: Add extra initialization here
	
	return TRUE;  // return TRUE  unless you set the focus to a control
}


void CPCI_104_CE_TestDlg::OnOpenCANPort() 
{
	// TODO: Add your control notification handler code here
	char cTemp[20];

	ConfigStruct CANConfig;
	
	UpdateData();

	m_Board.GetWindowText(wTemp,10);
	wcstombs(cTemp,wTemp,10);
	iBoard=(BYTE)atoi(cTemp);

	m_Port.GetWindowText(wTemp,10);
	wcstombs(cTemp,wTemp,10);
	iPort=(BYTE)atoi(cTemp);
		
	iRet=CAN_Init(iBoard,iPort);

	wsprintf(wTemp,L"%d",iRet);

	if(iRet)
		MessageBox(wTemp,NULL,MB_OK);
	else
	{
		m_AM0.GetWindowText(wTemp,10);
		wcstombs(cTemp,wTemp,10);
		sscanf(cTemp,"%02X",&Data);
		CANConfig.AccMask[0]=Data;

		m_AM1.GetWindowText(wTemp,10);
		wcstombs(cTemp,wTemp,10);
		sscanf(cTemp,"%02X",&Data);
		CANConfig.AccMask[1]=Data;

		m_AM2.GetWindowText(wTemp,10);
		wcstombs(cTemp,wTemp,10);
		sscanf(cTemp,"%02X",&Data);
		CANConfig.AccMask[2]=Data;

		m_AM3.GetWindowText(wTemp,10);
		wcstombs(cTemp,wTemp,10);
		sscanf(cTemp,"%02X",&Data);
		CANConfig.AccMask[3]=Data;

		m_AC0.GetWindowText(wTemp,10);
		wcstombs(cTemp,wTemp,10);
		sscanf(cTemp,"%02X",&Data);
		CANConfig.AccCode[0] = Data;

		m_AC1.GetWindowText(wTemp,10);
		wcstombs(cTemp,wTemp,10);
		sscanf(cTemp,"%02X",&Data);
		CANConfig.AccCode[1]=Data;

		m_AC2.GetWindowText(wTemp,10);
		wcstombs(cTemp,wTemp,10);
		sscanf(cTemp,"%02X",&Data);
		CANConfig.AccCode[2]=Data;

		m_AC3.GetWindowText(wTemp,10);
		wcstombs(cTemp,wTemp,10);
		sscanf(cTemp,"%02X",&Data);
		CANConfig.AccCode[3]=Data;
		
		CANConfig.BaudRate = m_BaudRate.GetCurSel()+1;
		
		iRet=CAN_Config(iBoard,iPort,&CANConfig);
	
		wsprintf(wTemp,L"%d",iRet);
		if(iRet)
			MessageBox(wTemp,L"Configure fail",MB_OK);	
	}
}

void CPCI_104_CE_TestDlg::OnClosePort() 
{
	// TODO: Add your control notification handler code here
	UpdateData();
	
	m_Board.GetWindowText(wTemp,10);
	wcstombs(cTemp,wTemp,10);
	iBoard=(BYTE)atoi(cTemp);

	m_Port.GetWindowText(wTemp,10);
	wcstombs(cTemp,wTemp,10);
	iPort=(BYTE)atoi(cTemp);

	iRet=CAN_Reset(iBoard,iPort);
	wsprintf(wTemp,L"%d",iRet);
	if(iRet)
		MessageBox(NULL,wTemp,MB_OK);

}

void CPCI_104_CE_TestDlg::OnSend() 
{
	// TODO: Add your control notification handler code here
	
	UpdateData();
	
	m_Board.GetWindowText(wTemp,10);
	wcstombs(cTemp,wTemp,10);
	iBoard=(BYTE)atoi(cTemp);

	m_Port.GetWindowText(wTemp,10);
	wcstombs(cTemp,wTemp,10);
	iPort=(BYTE)atoi(cTemp);

	m_Mode.GetWindowText(wTemp,5);
	wcstombs(cTemp,wTemp,5);
	CanPacket.Mode = atoi(cTemp);
	
	m_RTR.GetWindowText(wTemp,5);
	wcstombs(cTemp,wTemp,5);
	CanPacket.RTR = atoi(cTemp);
	
	m_ID.GetWindowText(wTemp,10);
	wcstombs(cTemp,wTemp,10);
	sscanf(cTemp,"%lX",&ID);
	
	CanPacket.id[0] = ID;
	CanPacket.id[1] = ID >> 8;
	CanPacket.id[2] = ID >> 16;
	CanPacket.id[3] = ID >> 24;
	
	m_Len.GetWindowText(wTemp,5);
	wcstombs(cTemp,wTemp,5);
	CanPacket.len=atoi(cTemp);
	if (CanPacket.len > 8)
		CanPacket.len = 8;

	m_D0.GetWindowText(wTemp,5);
	wcstombs(cTemp,wTemp,5);
	sscanf(cTemp,"%02X",&Data);
	CanPacket.data[0] = Data;
	
	m_D1.GetWindowText(wTemp,5);
	wcstombs(cTemp,wTemp,5);
	sscanf(cTemp,"%02X",&Data);
	CanPacket.data[1] = Data;
	
	m_D2.GetWindowText(wTemp,5);
	wcstombs(cTemp,wTemp,5);
	sscanf(cTemp,"%02X",&Data);
	CanPacket.data[2] = Data;
	
	m_D3.GetWindowText(wTemp,5);
	wcstombs(cTemp,wTemp,5);
	sscanf(cTemp,"%02X",&Data);
	CanPacket.data[3] = Data;
	
	m_D4.GetWindowText(wTemp,5);
	wcstombs(cTemp,wTemp,5);
	sscanf(cTemp,"%02X",&Data);
	CanPacket.data[4] = Data;
	
	m_D5.GetWindowText(wTemp,5);
	wcstombs(cTemp,wTemp,5);
	sscanf(cTemp,"%02X",&Data);
	CanPacket.data[5] = Data;
	
	m_D6.GetWindowText(wTemp,5);
	wcstombs(cTemp,wTemp,5);
	sscanf(cTemp,"%02X",&Data);
	CanPacket.data[6] = Data;
	
	m_D7.GetWindowText(wTemp,5);
	wcstombs(cTemp,wTemp,5);
	sscanf(cTemp,"%02X",&Data);
	CanPacket.data[7] = Data;
	
	iRet=CAN_SendMsg(iBoard,iPort,&CanPacket);
	if(iRet !=0 )
	{
		wsprintf(wTemp,L"%d",iRet);
		MessageBox(wTemp,NULL,MB_OK);
	}
}



void CPCI_104_CE_TestDlg::OnRecv() 
{
	// TODO: Add your control notification handler code here
	UpdateData();
	m_Board.GetWindowText(wTemp,10);
	wcstombs(cTemp,wTemp,10);
	iBoard=(BYTE)atoi(cTemp);

	m_Port.GetWindowText(wTemp,10);
	wcstombs(cTemp,wTemp,10);
	iPort=(BYTE)atoi(cTemp);

	SetTimer(1,100,NULL);
}

void CPCI_104_CE_TestDlg::OnTimer(UINT nIDEvent) 
{
	// TODO: Add your message handler code here and/or call default
	UpdateData ();
    
	iRet=CAN_ReceiveMsg(iBoard,iPort,&CanPacket);
	
	if(!iRet){
		//m_Receive.ShowWindow(SW_SHOWNORMAL);
		
		wsprintf(wTemp,L"%lu",lCounter);
		m_Receive.InsertItem(lCounter,wTemp);

		wsprintf(wTemp,L"%d",CanPacket.Mode);
		
		m_Receive.SetItemText(lCounter,1,wTemp);
			
		ID = CanPacket.id[3];
		ID = (ID << 8) | CanPacket.id[2];
		ID = (ID << 8) | CanPacket.id[1];
		ID = (ID << 8) | CanPacket.id[0];
		wsprintf(wTemp,L"%lx",ID);
		m_Receive.SetItemText(lCounter,2,wTemp);

		wsprintf(wTemp,L"%d",CanPacket.RTR);
		m_Receive.SetItemText(lCounter,3,wTemp);

		wsprintf(wTemp,L"%d",CanPacket.len);
		m_Receive.SetItemText(lCounter,4,wTemp);
		
		for (int i = 0; i < CanPacket.len; i++)
		{
			wsprintf (wTemp, TEXT("%02X"), CanPacket.data[i]);
			m_Receive.SetItemText(lCounter,i+5,wTemp);
		}
		//wsprintf(szBuffer,L"%X %d %d %d %s",ID,reciveTest.Mode,reciveTest.RTR,reciveTest.len,lBuffer);
		//m_show.SetWindowText(szBuffer);
		lCounter++;
		}
		else
		{
			wsprintf(wTemp,L"%d",iRet);	
			MessageBox(wTemp,NULL,MB_OK);	
		}

	CDialog::OnTimer(nIDEvent);
}

void CPCI_104_CE_TestDlg::OnStop() 
{
	// TODO: Add your control notification handler code here
	KillTimer(1);
}
