//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop

#include "Unit1.h"
#include "can.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TForm1 *Form1;
int ret;
double SystemFreq;
const P1=1,P2=2,Board=0;
ConfigStruct CanStruct;
PacketStruct TxPacket,RxPacket;
//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
    : TForm(Owner)
{
}
//---------------------------------------------------------------------------

void __fastcall TForm1::btnExitClick(TObject *Sender)
{
 ret=CAN_CloseBoard(Board);
 Close();
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Button1Click(TObject *Sender)
{
 TxPacket.mode=0;
 TxPacket.id=StrToInt("0x"+edtTXid->Text);
 TxPacket.rtr=(BYTE)StrToInt(edtTXrtr->Text);
 TxPacket.len=(BYTE)StrToInt(edtTXlen->Text);
 if(chk1->Checked)  TxPacket.mode=1;
 TxPacket.data[0]= (BYTE)StrToInt("0x"+edtTXdata1->Text);
 TxPacket.data[1]= (BYTE)StrToInt("0x"+edtTXdata2->Text);
 TxPacket.data[2]= (BYTE)StrToInt("0x"+edtTXdata3->Text);
 TxPacket.data[3]= (BYTE)StrToInt("0x"+edtTXdata4->Text);
 TxPacket.data[4]= (BYTE)StrToInt("0x"+edtTXdata5->Text);
 TxPacket.data[5]= (BYTE)StrToInt("0x"+edtTXdata6->Text);
 TxPacket.data[6]= (BYTE)StrToInt("0x"+edtTXdata7->Text);
 TxPacket.data[7]= (BYTE)StrToInt("0x"+edtTXdata8->Text);

 ret=CAN_SendMsg(Board,P1,&TxPacket);
 if(ret) Application->MessageBox("CAN_SendMsg Error!","Error",0+16);
}
//---------------------------------------------------------------------------

void __fastcall TForm1::FormActivate(TObject *Sender)
{
  int i;
  LONGLONG SystemHexFreq;
  ret=CAN_ActiveBoard(Board);
  if(ret) Application->MessageBox("CAN_ActiveBoard Error!","Error",0+16);

  ret=CAN_Reset(Board,P1);
  if(ret) Application->MessageBox("CAN_Reset Port 1 Error!","Error",0+16);
  ret=CAN_Reset(Board,P2);
  if(ret) Application->MessageBox("CAN_Reset Port2 Error!","Error",0+16);

  for(i=0;i<4;i++)
  {
   CanStruct.AccCode[i]=0;
   CanStruct.AccMask[i]=0xff;
  }
  CanStruct.BaudRate=5; //4:125K bps

  ret=CAN_Init(Board,P1);
  if(ret) Application->MessageBox("CAN_Init Port 1 Error!","Error",0+16);

  ret=CAN_Config(Board,P1,&CanStruct);
  if(ret) Application->MessageBox("CAN_Config Port 1 Error!","Error",0+16);

  ret=CAN_Init(Board,P2);
  if(ret) Application->MessageBox("CAN_Init Port 2 Error!","Error",0+16);
  ret=CAN_Config(Board,P2,&CanStruct);
  if(ret) Application->MessageBox("CAN_Config Port 2 Error!","Error",0+16);

  SystemHexFreq=CAN_GetSystemFreq();
  if (SystemHexFreq==0){
    SystemHexFreq=1; //avoid to divide zero
  }
  SystemFreq=SystemHexFreq;
}
//---------------------------------------------------------------------------

void __fastcall TForm1::btnRXClick(TObject *Sender)
{
 int i,j,k;
 int idl;
 double ReceiveTimeStamp;
 String tmp;
 Memo1->Clear();

 i=CAN_RxMsgCount(Board,P2);
 if(i==0) return;
 for(j=0;j<i;j++)
 {
   ret=CAN_ReceiveMsg(Board,P2,&RxPacket);
   if(ret)
   {
    Application->MessageBox("CAN_Receive Error!","Error",0+16);
    return;
   }
   if(RxPacket.mode) idl=8;
   else idl=3;
   tmp= IntToStr(j+1)+"  Mode:" + IntToStr(RxPacket.mode)+"  ID:"
       +IntToHex((int)RxPacket.id,idl)+"h  RTR:"
       + IntToStr(RxPacket.rtr)+ "  DLC:"+ IntToStr(RxPacket.len)+
       "  DATA(hex): ";
    for(k=0;k<RxPacket.len;k++)
    {
     tmp+=IntToHex(RxPacket.data[k],2)+" ";
    }
    ReceiveTimeStamp=RxPacket.MsgTimeStamps;
    tmp+= "  TimeStamp=" + FloatToStr(ReceiveTimeStamp/SystemFreq) + " (sec)" ;
   Memo1->Lines->Add(tmp);
 }
 
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Timer1Timer(TObject *Sender)
{
 BYTE bStatus;
 ret=CAN_Status(Board,P1,&bStatus);
 if(!ret) edtTxS->Text=IntToHex(bStatus,2);
 ret=CAN_Status(Board,P2,&bStatus);
 if(!ret) edtRxS->Text=IntToHex(bStatus,2);
}
//---------------------------------------------------------------------------

void __fastcall TForm1::btnClsDORClick(TObject *Sender)
{
 ret=CAN_ClearDataOverrun(Board,P2);
 if(ret) Application->MessageBox("CAN_ClearDataOverrun Error!","Error",0+16);
}
//---------------------------------------------------------------------------

