VERSION 5.00
Begin VB.Form frmDemo2 
   Caption         =   "PISO-CAN400/200 demo2"
   ClientHeight    =   4905
   ClientLeft      =   60
   ClientTop       =   345
   ClientWidth     =   10710
   LinkTopic       =   "Form1"
   ScaleHeight     =   4905
   ScaleWidth      =   10710
   StartUpPosition =   2  'CenterScreen
   Begin VB.Timer Timer1 
      Interval        =   500
      Left            =   8760
      Top             =   0
   End
   Begin VB.CommandButton cmdExit 
      Caption         =   "EXIT"
      BeginProperty Font 
         Name            =   "Arial"
         Size            =   12
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   570
      Left            =   9360
      TabIndex        =   2
      Top             =   240
      Width           =   1215
   End
   Begin VB.Frame Frame2 
      Caption         =   "Port 2 "
      BeginProperty Font 
         Name            =   "Arial"
         Size            =   12
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H00FF0000&
      Height          =   2640
      Left            =   225
      TabIndex        =   1
      Top             =   2160
      Width           =   9105
      Begin VB.CommandButton cmdRX 
         Caption         =   "Receive"
         BeginProperty Font 
            Name            =   "Arial"
            Size            =   9.75
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   465
         Left            =   7080
         TabIndex        =   14
         Top             =   1920
         Width           =   1440
      End
      Begin VB.TextBox Text1 
         Height          =   1215
         Left            =   150
         MultiLine       =   -1  'True
         ScrollBars      =   2  'Vertical
         TabIndex        =   13
         Top             =   450
         Width           =   8745
      End
      Begin VB.Label Label15 
         Caption         =   "Status"
         BeginProperty Font 
            Name            =   "Arial"
            Size            =   9.75
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   315
         Left            =   4920
         TabIndex        =   24
         Top             =   2025
         Width           =   615
      End
      Begin VB.Label lblStatus2 
         Alignment       =   1  'Right Justify
         BorderStyle     =   1  'Fixed Single
         BeginProperty Font 
            Name            =   "Arial"
            Size            =   11.25
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   390
         Left            =   5640
         TabIndex        =   23
         Top             =   1980
         Width           =   1245
      End
   End
   Begin VB.Frame Frame1 
      Caption         =   "Port 1 "
      BeginProperty Font 
         Name            =   "Arial"
         Size            =   12
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H00FF0000&
      Height          =   1965
      Left            =   240
      TabIndex        =   0
      Top             =   120
      Width           =   9105
      Begin VB.TextBox txtTXdata 
         Alignment       =   1  'Right Justify
         BeginProperty Font 
            Name            =   "Arial"
            Size            =   9.75
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   390
         Index           =   0
         Left            =   3000
         TabIndex        =   33
         Text            =   "11"
         Top             =   600
         Width           =   510
      End
      Begin VB.TextBox txtTXdata 
         Alignment       =   1  'Right Justify
         BeginProperty Font 
            Name            =   "Arial"
            Size            =   9.75
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   390
         Index           =   1
         Left            =   3720
         TabIndex        =   32
         Text            =   "22"
         Top             =   600
         Width           =   510
      End
      Begin VB.TextBox txtTXdata 
         Alignment       =   1  'Right Justify
         BeginProperty Font 
            Name            =   "Arial"
            Size            =   9.75
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   390
         Index           =   2
         Left            =   4440
         TabIndex        =   31
         Text            =   "33"
         Top             =   600
         Width           =   510
      End
      Begin VB.TextBox txtTXdata 
         Alignment       =   1  'Right Justify
         BeginProperty Font 
            Name            =   "Arial"
            Size            =   9.75
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   390
         Index           =   3
         Left            =   5160
         TabIndex        =   30
         Text            =   "44"
         Top             =   600
         Width           =   510
      End
      Begin VB.TextBox txtTXdata 
         Alignment       =   1  'Right Justify
         BeginProperty Font 
            Name            =   "Arial"
            Size            =   9.75
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   390
         Index           =   4
         Left            =   5880
         TabIndex        =   29
         Text            =   "55"
         Top             =   600
         Width           =   510
      End
      Begin VB.TextBox txtTXdata 
         Alignment       =   1  'Right Justify
         BeginProperty Font 
            Name            =   "Arial"
            Size            =   9.75
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   390
         Index           =   5
         Left            =   6600
         TabIndex        =   28
         Text            =   "66"
         Top             =   600
         Width           =   510
      End
      Begin VB.TextBox txtTXdata 
         Alignment       =   1  'Right Justify
         BeginProperty Font 
            Name            =   "Arial"
            Size            =   9.75
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   390
         Index           =   6
         Left            =   7320
         TabIndex        =   27
         Text            =   "77"
         Top             =   600
         Width           =   510
      End
      Begin VB.TextBox txtTXdata 
         Alignment       =   1  'Right Justify
         BeginProperty Font 
            Name            =   "Arial"
            Size            =   9.75
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   390
         Index           =   7
         Left            =   8040
         TabIndex        =   26
         Text            =   "88"
         Top             =   600
         Width           =   510
      End
      Begin VB.CheckBox Check1 
         Caption         =   "Extened (29-bit ID)"
         BeginProperty Font 
            Name            =   "Arial"
            Size            =   9.75
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   390
         Left            =   240
         TabIndex        =   11
         Top             =   1275
         Width           =   2100
      End
      Begin VB.CommandButton cmdTX 
         Caption         =   "Send"
         BeginProperty Font 
            Name            =   "Arial"
            Size            =   9.75
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   465
         Left            =   7080
         TabIndex        =   10
         Top             =   1275
         Width           =   1440
      End
      Begin VB.TextBox txtTXrtr 
         Alignment       =   2  'Center
         BeginProperty Font 
            Name            =   "Arial"
            Size            =   9.75
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   390
         Left            =   1560
         MaxLength       =   1
         TabIndex        =   5
         Text            =   "0"
         Top             =   600
         Width           =   435
      End
      Begin VB.TextBox txtTXlen 
         Alignment       =   1  'Right Justify
         BeginProperty Font 
            Name            =   "Arial"
            Size            =   9.75
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   390
         Left            =   2160
         MaxLength       =   1
         TabIndex        =   4
         Text            =   "8"
         Top             =   600
         Width           =   435
      End
      Begin VB.TextBox txtTXid 
         Alignment       =   1  'Right Justify
         BeginProperty Font 
            Name            =   "Arial"
            Size            =   9.75
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   390
         Left            =   240
         TabIndex        =   3
         Text            =   "123"
         Top             =   600
         Width           =   1065
      End
      Begin VB.Label lblStatus1 
         Alignment       =   1  'Right Justify
         BorderStyle     =   1  'Fixed Single
         BeginProperty Font 
            Name            =   "Arial"
            Size            =   11.25
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   390
         Left            =   5640
         TabIndex        =   22
         Top             =   1320
         Width           =   1260
      End
      Begin VB.Label Label16 
         Caption         =   "Status"
         BeginProperty Font 
            Name            =   "Arial"
            Size            =   9.75
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   315
         Left            =   4920
         TabIndex        =   25
         Top             =   1320
         Width           =   615
      End
      Begin VB.Label Label12 
         Caption         =   "8"
         Height          =   165
         Left            =   8280
         TabIndex        =   21
         Top             =   375
         Width           =   165
      End
      Begin VB.Label Label11 
         Caption         =   "7"
         Height          =   165
         Left            =   7560
         TabIndex        =   20
         Top             =   375
         Width           =   165
      End
      Begin VB.Label Label10 
         Caption         =   "6"
         Height          =   165
         Left            =   6840
         TabIndex        =   19
         Top             =   375
         Width           =   165
      End
      Begin VB.Label Label7 
         Caption         =   "5"
         Height          =   165
         Left            =   6120
         TabIndex        =   17
         Top             =   375
         Width           =   165
      End
      Begin VB.Label Label6 
         Caption         =   "4"
         Height          =   165
         Left            =   5400
         TabIndex        =   16
         Top             =   375
         Width           =   165
      End
      Begin VB.Label Label5 
         Caption         =   "3"
         Height          =   165
         Left            =   4680
         TabIndex        =   15
         Top             =   360
         Width           =   165
      End
      Begin VB.Label Label8 
         Caption         =   "2"
         Height          =   165
         Left            =   3960
         TabIndex        =   12
         Top             =   375
         Width           =   165
      End
      Begin VB.Label Label4 
         Caption         =   "1"
         Height          =   165
         Left            =   3240
         TabIndex        =   9
         Top             =   360
         Width           =   165
      End
      Begin VB.Label Label3 
         Caption         =   "DLC"
         Height          =   165
         Left            =   2160
         TabIndex        =   8
         Top             =   360
         Width           =   390
      End
      Begin VB.Label Label2 
         Caption         =   "RTR"
         Height          =   165
         Left            =   1560
         TabIndex        =   7
         Top             =   360
         Width           =   390
      End
      Begin VB.Label Label1 
         Caption         =   "ID (hex)"
         Height          =   165
         Left            =   480
         TabIndex        =   6
         Top             =   360
         Width           =   690
      End
   End
   Begin VB.Label Label9 
      Caption         =   "2"
      Height          =   165
      Left            =   5100
      TabIndex        =   18
      Top             =   750
      Width           =   165
   End
End
Attribute VB_Name = "frmDemo2"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit
Dim CanConfig As ConfigStruct
Dim CANTx As PacketStruct
Dim CANRx As PacketStruct
Dim SystemFreq As Double
Dim ret As Integer
Const B0 = 0            'B0=0 => BoardNo:0
Const P1 = 1, P2 = 2   'P1 => Port 1 , P2=> Port 2

Private Sub cmdExit_Click()
 Unload Me
End Sub

Private Sub cmdRX_Click() 'Receive message
 Dim i As Integer, j As Integer, k As Integer
 Dim RxS As String, RxS2 As String, Temp As String
 Dim ReceiveTimeStamp As Double
 
 RxS = ""
 Text1.Text = ""
 
 CANRx.Id = 0
 
  i = CAN_RxMsgCount(B0, P2)
  If i = 0 Then Exit Sub
  
  For j = 1 To i
    ret = CAN_ReceiveMsg(B0, P2, CANRx)
    If ret <> 0 Then
       MsgBox "CAN_ReceiveMsg error!  Code:" & Str(ret), vbCritical, "Error"
    End If
    RxS = RxS & Format(j, "00") & "  Mode:" & Str(CANRx.Mode) & "  ID:" & Hex(CANRx.Id) _
        & "h  RTR:" & Str(CANRx.Rtr) & "  DLC:" & Str(CANRx.Dlen) & "  Data(hex):"
    For k = 0 To CANRx.Dlen - 1
       Temp = Hex$(CANRx.Data(k))
       If Len(Temp) = 1 Then Temp = "0" + Temp
       RxS = RxS & Temp & " "
    Next k
    ReceiveTimeStamp = LongLongToUnLongLong(CANRx.MsgTimeStamps)
    RxS = RxS & "TimeStamp=" & (ReceiveTimeStamp / SystemFreq) & "sec" & Chr(13) & Chr(10)
  Next j
  Text1 = RxS
End Sub

Private Sub cmdTX_Click() 'Transmit message
 Dim i As Integer

  If Check1.Value = 1 Then
     CANTx.Mode = 1
  Else
     CANTx.Mode = 0
  End If
  
  CANTx.Id = Val("&H" & txtTXid.Text)
  CANTx.Rtr = Val(txtTXrtr.Text)
  CANTx.Dlen = Val(txtTXlen.Text)
  
  For i = 0 To CANTx.Dlen - 1
    CANTx.Data(i) = Val("&H" & txtTXdata(i).Text)
  Next i
  
  ret = CAN_SendMsg(B0, P1, CANTx)
  If ret <> 0 Then
    MsgBox "CAN_SendMsg error!  Code:" & Str(ret), vbCritical, "Error"
  End If
  DoEvents
   
End Sub


Private Sub Form_Load()
 Dim i As Integer
 Dim SystemHexFreq As LongLong
 Dim Temp1 As Long, Temp2 As Long

 ret = CAN_ActiveBoard(B0)
 If ret <> 0 Then
    MsgBox "CAN_ActiveBoard error!  Code:" & Str(ret), vbCritical, "Error"
    Unload Me
 End If
 
 ret = CAN_Reset(B0, P1)
 If ret <> 0 Then
    MsgBox "CAN_Reset error!  Code:" & Str(ret), vbCritical, "Error"
    Unload Me
 End If
 ret = CAN_Reset(B0, P2)
 If ret <> 0 Then
    MsgBox "CAN_Reset error!  Code:" & Str(ret), vbCritical, "Error"
    Unload Me
 End If
  
 ret = CAN_Init(B0, P1)
 If ret <> 0 Then
    MsgBox "CAN_Init error!  Code:" & Str(ret), vbCritical, "Error"
 End If
 
 For i = 0 To 3
    CanConfig.AccCode(i) = 0
    CanConfig.AccMask(i) = &HFF
 Next i
 CanConfig.BaudRate = 5  '5:250Kbps
 
 ret = CAN_Config(B0, P1, CanConfig)
 If ret <> 0 Then
    MsgBox "CAN_Config error!  Code:" & Str(ret), vbCritical, "Error"
 End If
 
 ret = CAN_Init(B0, P2)
 If ret <> 0 Then
    MsgBox "CAN_Init error!  Code:" & Str(ret), vbCritical, "Error"
 End If
 
 ret = CAN_Config(B0, P2, CanConfig)
 If ret <> 0 Then
    MsgBox "CAN_Config error!  Code:" & Str(ret), vbCritical, "Error"
 End If
 
 ret = CAN_EnableRxIrq(B0, P2)
 If ret <> 0 Then
    MsgBox "CAN_EnableRxIrq error!  Code:" & Str(ret), vbCritical, "Error"
    Exit Sub
 End If
 
 ret = CAN_InstallIrq(B0)
 If ret <> 0 Then
    MsgBox "CAN_InstallIrq error!  Code:" & Str(ret), vbCritical, "Error"
 End If
 
 SystemHexFreq = CAN_GetSystemFreq()
 SystemFreq = LongLongToUnLongLong(SystemHexFreq)
 If SystemFreq = 0 Then
    MsgBox "Get SystemFreq error!"
    SystemFreq = 1 'avoid to divide zero
 End If

End Sub

Private Sub Form_Unload(Cancel As Integer)
 ret = CAN_RemoveIrq(B0)
 If ret <> 0 Then
    MsgBox "CAN_RemoveIrq error!  Code:" & Str(ret), vbCritical, "Error"
 End If
 
 ret = CAN_CloseBoard(B0)
 End
End Sub

Private Sub Timer1_Timer()
 Dim status As Byte
 Dim tret As Integer
 tret = CAN_Status(B0, P1, status)
 If tret = 0 Then
    lblStatus1.Caption = Hex$(status)
 Else
    lblStatus1.Caption = ""
 End If
 status = 0
 tret = CAN_Status(B0, P2, status)
 If tret = 0 Then
    lblStatus2.Caption = Hex$(status)
 Else
    lblStatus2.Caption = ""
 End If
 
End Sub

Private Function LongLongToUnLongLong(InputValue As LongLong) As Double
Dim TempHighLong As Double, TempLowLong As Double, TempScale As Double

TempScale = &H7FFFFFFF
TempHighLong = InputValue.HighLong
If (InputValue.HighLong < 0) Then
TempHighLong = 2 * (TempScale + 1) + InputValue.HighLong
End If

TempLowLong = InputValue.LowLong
If (InputValue.LowLong < 0) Then
TempLowLong = 2 * (TempScale + 1) + InputValue.LowLong
End If

LongLongToUnLongLong = TempHighLong * 2 * (TempScale + 1) + TempLowLong
End Function
