Attribute VB_Name = "Module1"
Option Explicit
'--------------------------------------------------
' Dll Function Return Code
'--------------------------------------------------
' CAN_NoError                    0
' CAN_DriverError                1
' CAN_ActiveBoardError           2
' CAN_BoardNumberError           3
' CAN_PortNumberError            4
' CAN_ResetError                 5
' CAN_SoftResetError             6
' CAN_InitError                  7
' CAN_ConfigError                8
' CAN_SetACRError                9
' CAN_SetAMRError                10
' CAN_SetBaudRateError           11
'
' CAN_EnableRxIrqFailure         12
' CAN_DisableRxIrqFailure        13
' CAN_InstallIrqFailure          14
' CAN_RemoveIrqFailure           15
'
' CAN_TransmitBufferLocked       16
' CAN_TransmitIncomplete         17
' CAN_ReceiveBufferEmpty         18
' CAN_DataOverrun                19
' CAN_ReceiveError               20
' CAN_SoftBufferIsEmpty          21
' CAN_SoftBufferIsFull           22
' CAN_TimeOut                    23

' CAN_InstallIsrError            24
'-------------------------------------------------

Public Type ConfigStruct
 AccCode(3) As Byte
 AccMask(3) As Byte
 BaudRate As Byte
 BT0 As Byte
 BT1 As Byte
End Type
'BaudRate 0:user define 1=10K   2=20K   3=50K  4=125K  5=250K  6=500K 7=800K  8=1Mbps

Public Type LongLong
 LowLong As Long
 HighLong As Long
End Type

Public Type PacketStruct
 MsgTimeStamps As LongLong
 Mode As Byte
 Id As Long
 Rtr As Byte
 Dlen As Byte
 Data(7) As Byte
End Type
'mode 0 -> 11 bits ID    1 -> 29 bits ID


Declare Function CAN_GetDllVersion Lib "pisocan.dll" () As Integer

Declare Function CAN_ActiveBoard Lib "pisocan.dll" (ByVal BoardNo As Byte) As Integer
Declare Function CAN_CloseBoard Lib "pisocan.dll" (ByVal BoardNo As Byte) As Integer
   
Declare Function CAN_TotalBoard Lib "pisocan.dll" () As Integer
Declare Function CAN_GetBoardInf Lib "pisocan.dll" (ByVal BoardNo As Byte, dwVID As Long, dwDID As Long, _
                                                    dwSVID As Long, dwSDID As Long, dwSAuxID As Long, _
                                                    dwIrqNo As Long) As Integer
                                        
Declare Function CAN_GetCardPortNum Lib "pisocan.dll" (ByVal BoardNo As Byte, bGetPortNum As Byte) As Integer

Declare Function CAN_BoardIsActive Lib "pisocan.dll" (ByVal BoardNo As Byte) As Integer
            
Declare Function CAN_Reset Lib "pisocan.dll" _
   (ByVal BoardNo As Byte, ByVal Port As Byte) As Integer
Declare Function CAN_Init Lib "pisocan.dll" _
   (ByVal BoardNo As Byte, ByVal Port As Byte) As Integer
   
Declare Function CAN_Config Lib "pisocan.dll" _
   (ByVal BoardNo As Byte, ByVal Port As Byte, CanConfig As ConfigStruct) As Integer
Declare Function CAN_ConfigWithoutStruct Lib "pisocan.dll" _
   (ByVal BoardNo As Byte, ByVal Port As Byte, ByVal AccCode As Long, ByVal AccMask As Long, ByVal BaudRate As Byte, ByVal BT0 As Byte, ByVal BT1 As Byte) As Integer
   
Declare Function CAN_EnableRxIrq Lib "pisocan.dll" _
(ByVal BoardNo As Byte, ByVal Port As Byte) As Integer
Declare Function CAN_DisableRxIrq Lib "pisocan.dll" _
(ByVal BoardNo As Byte, ByVal Port As Byte) As Integer
Declare Function CAN_RxIrqStatus Lib "pisocan.dll" _
(ByVal BoardNo As Byte, ByVal Port As Byte, bStatus As Byte) As Integer
Declare Function CAN_InstallIrq Lib "pisocan.dll" _
(ByVal BoardNo As Byte) As Integer
Declare Function CAN_RemoveIrq Lib "pisocan.dll" _
(ByVal BoardNo As Byte) As Integer
Declare Function CAN_IrqStatus Lib "pisocan.dll" _
(ByVal BoardNo As Byte, bStatus As Byte) As Integer
Declare Function CAN_Status Lib "pisocan.dll" _
(ByVal BoardNo As Byte, ByVal Port As Byte, bStatus As Byte) As Integer
   
Declare Function CAN_SendMsg Lib "pisocan.dll" _
   (ByVal BoardNo As Byte, ByVal Port As Byte, CanPacket As PacketStruct) As Integer
Declare Function CAN_SendWithoutStruct Lib "pisocan.dll" _
   (ByVal BoardNo As Byte, ByVal Port As Byte, ByVal Mode As Byte, ByVal Id As Long, ByVal Rtr As Byte, ByVal Dlen As Byte, Data As Byte) As Integer

Declare Function CAN_RxMsgCount Lib "pisocan.dll" _
(ByVal BoardNo As Byte, ByVal Port As Byte) As Integer
Declare Function CAN_ReceiveMsg Lib "pisocan.dll" _
   (ByVal BoardNo As Byte, ByVal Port As Byte, CanPacket As PacketStruct) As Integer
Declare Function CAN_ReceiveWithoutStruct Lib "pisocan.dll" _
   (ByVal BoardNo As Byte, ByVal Port As Byte, Mode As Byte, Id As Long, Rtr As Byte, Dlen As Byte, Data As Byte, H_MsgTimeStamps As Long, L_MsgTimeStamps As Long) As Integer


Declare Function CAN_ClearSoftBuffer Lib "pisocan.dll" _
(ByVal BoardNo As Byte, ByVal Port As Byte) As Integer
Declare Function CAN_ClearDataOverrun Lib "pisocan.dll" _
(ByVal BoardNo As Byte, ByVal Port As Byte) As Integer


Declare Sub CAN_OutputByte Lib "pisocan.dll" _
   (ByVal BoardNo As Byte, ByVal Port As Byte, ByVal wOffset As Integer, ByVal bData As Byte)
Declare Function CAN_InputByte Lib "pisocan.dll" _
   (ByVal BoardNo As Byte, ByVal Port As Byte, ByVal wOffset As Integer) As Integer
   
Declare Function CAN_GetSystemFreq Lib "pisocan.dll" () As LongLong
     
Declare Function CAN_InstallUserIsr Lib "pisocan.dll" _
    (ByVal BoardNo As Byte, ByVal UserISR As Long) As Integer
    
Declare Function CAN_RemoveUserIsr Lib "pisocan.dll" (ByVal BoardNo As Byte) As Integer

