/********************************************************************/

/*  7188EX/7188XB/7186EX + X202 head file                           */

/*                                                                  */

/*  [07, Oct, 2005] by Liam                                         */

/*  [23, Mar, 2007] by Liam                                         */

/********************************************************************/

/********************************************************************/

/*  X202: 7 A/D channels (0~20mA)                                   */

/*                                                                  */

/********************************************************************/

/********************************************************************/

/*	[Caution]                                                       */

/*	The EEPROM block 7 on X board is used to store A/D calibration  */

/*	settings. When you use the EEPROM on X board, do not overwrite  */

/*  it.                                                             */

/********************************************************************/



#ifndef __X202_H

#define __X202_H



#ifdef __cplusplus

extern "C" {

#endif



#define Read_AD_CalibrationGain     X202_Read_AD_CalibrationGain

#define Read_AD_CalibrationOffset   X202_Read_AD_CalibrationOffset

#define fAD_Gain    X202_fAD_Gain

#define fAD_Offset  X202_fAD_Offset



int X202_Init(void);

/*  Return value: 0   ==> success

    Return value: <>0 ==> error

    Bit0: 1 ==> (Ch0)Reads A/D Gain falure

    Bit1: 1 ==> (Ch0)Reads A/D Offset falure    */



unsigned X202_GetLibVersion(void);

/*  Current version is 2.00 (return 0x0200) */



float X202_Read_AD_CalibrationGain(void);

/*  Return 10.0 when no setting in EEPROM   */



float X202_Read_AD_CalibrationOffset(void);

/*  Return 10.0 when no setting in EEPROM   */



float X202_AnalogIn(int iChannel);

/*  Return data = 0.0 ~ 20.0    */



extern float  X202_fAD_Gain, X202_fAD_Offset;



#ifdef __cplusplus

}

#endif



#endif