#include "hmiworks.h"

#define TICKS_PER_SECOND 100

#define APPLICATION_TITLE "ICPDAS-ICPDAS"
volatile tBoolean g_bFirmwareUpdate = false;

void SysTickIntHandler(void)
{
    hmi_TimerTrigger();
}


int main(void)
{
    SysCtlClockSet(SYSCTL_SYSDIV_4 | SYSCTL_USE_PLL | SYSCTL_OSC_MAIN | SYSCTL_XTAL_8MHZ);
    SysTickPeriodSet(SysCtlClockGet() / TICKS_PER_SECOND);
    SysTickEnable();
    SysTickIntEnable();

    for (int i=0; i<3; i++) //protect boot loader, don't remove!
          FlashProtectSet(2048*i, FlashReadOnly);
		  
    SoundInit();
    HMI_INIT(O_PORTRAIT);

    _frame0();

    TouchScreenInit();
    TouchScreenCallbackSet(WidgetPointerMessage);

    while(!g_bFirmwareUpdate)
    {
        WidgetMessageQueueProcess();
    }

    WidgetMessageQueueProcess();
    SysCtlDelay(SysCtlClockGet() / 6);
    SoftwareUpdateBegin();
    while(1) { }
}



