//*****************************************************************************
//
// param.h - Prototypes for the motor controller parameter block.
//
// Copyright (c) 2008-2009 Luminary Micro, Inc.  All rights reserved.
// Software License Agreement
// 
// Luminary Micro, Inc. (LMI) is supplying this software for use solely and
// exclusively on LMI's microcontroller products.
// 
// The software is owned by LMI and/or its suppliers, and is protected under
// applicable copyright laws.  All rights are reserved.  You may not combine
// this software with "viral" open-source software in order to form a larger
// program.  Any use in violation of the foregoing restrictions may subject
// the user to criminal sanctions under applicable laws, as well as to civil
// liability for the breach of the terms and conditions of this license.
// 
// THIS SOFTWARE IS PROVIDED "AS IS".  NO WARRANTIES, WHETHER EXPRESS, IMPLIED
// OR STATUTORY, INCLUDING, BUT NOT LIMITED TO, IMPLIED WARRANTIES OF
// MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE APPLY TO THIS SOFTWARE.
// LMI SHALL NOT, IN ANY CIRCUMSTANCES, BE LIABLE FOR SPECIAL, INCIDENTAL, OR
// CONSEQUENTIAL DAMAGES, FOR ANY REASON WHATSOEVER.
// 
// This is part of revision 4905 of the RDK-BDC Firmware Package.
//
//*****************************************************************************

#ifndef __PARAMS_H__
#define __PARAMS_H__

//*****************************************************************************
//
// This structure contains the parameter block for the motor controller.  The
// size of this structure must be FLASH_PB_SIZE bytes; if it is larger then the
// end of the parameter block will not get saved to flash, and if it is smaller
// then whatever appears in SRAM after the parameter block will get saved to
// flash (which could cause problems if the firmware is updated and the
// parameter block in the updated firmware has more parameters and therefore
// tries to use those values).
//
//*****************************************************************************
typedef struct
{
    //
    // The sequence number of this parameter block.  When in RAM, this value is
    // not used.  When in flash, this value is used to determine the parameter
    // block with the most recent information.
    //
    unsigned char ucSequenceNum;

    //
    // The CRC of the parameter block.  When in RAM, this value is not used.
    // When in flash, this value is used to validate the contents of the
    // parameter block (to avoid using a partially written parameter block).
    //
    unsigned char ucCRC;

    //
    // The version of this parameter block.  This can be used to distinguish
    // saved parameters that correspond to an old version of the parameter
    // block.
    //
    unsigned char ucVersion;

	//PRESERVE ABOVE THREE PARAMETERS FOR FLASH READ/WRITE

	//int counts;
	
	//unsigned char Macaddr[7];
	
        //unsigned char net_id;
	
	//int IP[4];
	
	//BOOL tEthernet;
	
	int CalibrateNum[7];
	
	int tInitstatus;
	
    //
    // Padding to ensure the whole structure is 64 bytes long.
    //
    unsigned char ucReserved[93];
}
tParameters;

//*****************************************************************************
//
// Prototypes.
//
//*****************************************************************************
extern tParameters g_sParameters;
extern void ParamInit(void);
extern void ParamLoadDefault(void);
extern void ParamLoad(void);
extern void ParamSave(void);

//*****************************************************************************
//
// The address of the last block of flash to be used for storing parameters.
// Since the end of flash is used for parameters, this is actually the first
// address past the end of flash.
//
//*****************************************************************************
#define FLASH_PB_END            0x3FC00

//*****************************************************************************
//
// The address of the first block of flash to be used for storing parameters.
//
//*****************************************************************************
#define FLASH_PB_START          (FLASH_PB_END - 0x800)

//*****************************************************************************
//
// The size of the parameter block to save.  This must be a power of 2, and
// should be large enough to contain the tParameters structure.
//
//*****************************************************************************
#define FLASH_PB_SIZE           128



#endif // __PARAM_H__
