#include "hmiworks.h"

int _CurrentFrame = 0;

char *g_FrameNames[] = 
{
  "Frame1",
  "Frame2",
  "Frame3",
};

const int g_FrameCount = (sizeof(g_FrameNames)/sizeof(char *));



void CheckModbus()
{

}
int g_TimerTicksCount;
void hmi_TimerTrigger()
{
  g_TimerTicksCount++;
  if (table_init_flag && (g_TimerTicksCount%(100/10)) == 0) AddQueueMessage(0);
  
  if ((g_TimerTicksCount%50) == 0) CheckModbus();
  
switch(_CurrentFrame) {
 case 1: {
    if ((g_TimerTicksCount % 100) == (100-1)) {
        WidgetTimerExecute((tWidget *)&Timer11);
  }
break;
 }
 case 2: {
break;
 }
 case 3: {
break;
 }
}
}


void FreeCurrentFrame()
{
     switch (_CurrentFrame)
     {
	case 1: FreeWidget1(); break;
	case 2: FreeWidget2(); break;
	case 3: FreeWidget3(); break;
     }
}


void hmi_GotoFrame(int nFrame)
{
    switch(nFrame)
    {
	case 1: _frame1(); break;
	case 2: _frame2(); break;
	case 3: _frame3(); break;
    }

}


int hmi_IndexOfFrame(const char *frame_name)
{
    int i;
    for (i=0; i<g_FrameCount; i++)
       if (strcmp(frame_name, g_FrameNames[i]) == 0) return i+1;
    return 0;
}


void hmi_GotoFrameByName(const char *frame_name)
{
    hmi_GotoFrame(hmi_IndexOfFrame(frame_name));
}

BYTE ladder_main(BYTE);
static BYTE r_out(BYTE);

long default_timer_proc(tWidget *pWidget, unsigned long ulMessage,
                     unsigned long ulParam1, unsigned long ulParam2)

{
  ladder_main(1);
  r_out(1);
  return 1;
}

static BYTE r_out(BYTE en)
{
  default_output(1);

  default_input(1);

return 0;
}

void _frame0()
{
  tContext sContext;
  
  hmi_Beep();
  hmi_Beep();
  
  
  RegisterNullWidgetMsgProc(default_timer_proc);
  
  GrContextInit(&sContext, HMI_DISPLAY_DRIVER_PTR);
  hmi_GotoFrame(1);
  GrFlush(&sContext);
}
