#include "params.h"
static volatile tBoolean g_bFirmwareUpdate = false;

void Frame25OnShow()
{
    long lIdx, lX1, lY1, lX2, lY2, lCount;
    long pplPoints[3][4];
    char pcBuffer[32];
    int flag = 789;
    tRectangle sRect;


    hmi_SetForeground(thisContext, 0x000000);
    hmi_FillRect(thisContext, 0, 0, 240, 320);

    // Fill the top 24 rows of the screen with white to create the banner.
    sRect.sXMin = 0;
    sRect.sYMin = 0;
    sRect.sXMax = GrContextDpyWidthGet(thisContext) - 1;
    sRect.sYMax = 23;
    GrContextForegroundSet(thisContext, ClrGreen);
    GrRectFill(thisContext, &sRect);

    // Put a white box around the banner.
    GrContextForegroundSet(thisContext, ClrYellow);
    GrRectDraw(thisContext, &sRect);

    // Put the application name in the middle of the banner.
    GrContextFontSet(thisContext, &g_sFontCm20);
    GrStringDrawCentered(thisContext, "calibrate", -1,
                         GrContextDpyWidthGet(thisContext) / 2, 11, 0);

   // Print the instructions across the middle of the screen in white with a
    // 20 point small-caps font.
    GrContextForegroundSet(thisContext, ClrYellow);
    GrContextFontSet(thisContext, &g_sFontCmsc20);
    GrStringDraw(thisContext, "Touch the box", -1, 0,
                 (GrContextDpyHeightGet(thisContext) / 2) - 10, 0);

    // Set the points used for calibration based on the size of the screen.
    pplPoints[0][0] = GrContextDpyWidthGet(thisContext) / 5;
    pplPoints[0][1] = GrContextDpyHeightGet(thisContext) / 5;
    pplPoints[1][0] = GrContextDpyWidthGet(thisContext) / 2;
    pplPoints[1][1] = (GrContextDpyHeightGet(thisContext) * 9) / 10;
    pplPoints[2][0] = (GrContextDpyWidthGet(thisContext) * 9) / 10;
    pplPoints[2][1] = GrContextDpyHeightGet(thisContext) / 2;

    // Loop through the calibration points.
    for(lIdx = 0; lIdx < 3; lIdx++)
    {
        // Fill a white box around the calibration point.
        GrContextForegroundSet(thisContext, ClrDarkRed);
        sRect.sXMin = pplPoints[lIdx][0] - 5;
        sRect.sYMin = pplPoints[lIdx][1] - 5;
        sRect.sXMax = pplPoints[lIdx][0] + 5;
        sRect.sYMax = pplPoints[lIdx][1] + 5;
        GrRectFill(thisContext, &sRect);

        // Flush any cached drawing operations.
        GrFlush(thisContext);

        // Initialize the raw sample accumulators and the sample count.
        lX1 = 0;
        lY1 = 0;
        lCount = -5;


        // Loop forever.  This loop is explicitly broken out of when the pen is
        // lifted or a firmware update request is received.
        while(!g_bFirmwareUpdate)
       {
            // Grab the current raw touch screen position.
            lX2 = g_sTouchX;
            lY2 = g_sTouchY;

            // See if the pen is up or down.
            if((lX2 < 100) || (lY2 < 100))
            {

               // The pen is up, so see if any samples have been accumulated.
                if(lCount > 0)
                {
                    // The pen has just been lifted from the screen, so break
                    // out of the controlling while loop.
                    break;
                }
               // Reset the accumulators and sample count.
                lX1 = 0;
                lY1 = 0;
                lCount = -5;
               // Grab the next sample.
                continue;
            }

            // Increment the count of samples.
            lCount++;

            // If the sample count is greater than zero, add this sample to the
            // accumulators.
            if(lCount > 0)
            {
                lX1 += lX2;
                lY1 += lY2;
            }

        }
        // Save the averaged raw ADC reading for this calibration point.
        pplPoints[lIdx][2] = lX1 / lCount;
        pplPoints[lIdx][3] = lY1 / lCount;

        // Erase the box around this calibration point.

        GrContextForegroundSet(thisContext, ClrBlack);
        GrRectFill(thisContext, &sRect);
    }
    usprintf(pcBuffer, "M0 = %d",
             (((pplPoints[0][0] - pplPoints[2][0]) *
               (pplPoints[1][3] - pplPoints[2][3])) -
              ((pplPoints[1][0] - pplPoints[2][0]) *
               (pplPoints[0][3] - pplPoints[2][3]))));
    GrStringDraw(thisContext, pcBuffer, -1, 0, 60, 0);

    int M0 =  (((pplPoints[0][0] - pplPoints[2][0]) *
               (pplPoints[1][3] - pplPoints[2][3])) -
              ((pplPoints[1][0] - pplPoints[2][0]) *
               (pplPoints[0][3] - pplPoints[2][3])));
               g_sParameters.CalibrateNum[0] = M0;

   usprintf(pcBuffer, "M1 = %d",
             (((pplPoints[0][2] - pplPoints[2][2]) *
               (pplPoints[1][0] - pplPoints[2][0])) -
              ((pplPoints[0][0] - pplPoints[2][0]) *
               (pplPoints[1][2] - pplPoints[2][2]))));
    GrStringDraw(thisContext, pcBuffer, -1, 0, 80, 0);

    int M1 = (((pplPoints[0][2] - pplPoints[2][2]) *
               (pplPoints[1][0] - pplPoints[2][0])) -
              ((pplPoints[0][0] - pplPoints[2][0]) *
               (pplPoints[1][2] - pplPoints[2][2])));
               g_sParameters.CalibrateNum[1] = M1;

    usprintf(pcBuffer, "M2 = %d",
             ((((pplPoints[2][2] * pplPoints[1][0]) -
                (pplPoints[1][2] * pplPoints[2][0])) * pplPoints[0][3]) +
              (((pplPoints[0][2] * pplPoints[2][0]) -
                (pplPoints[2][2] * pplPoints[0][0])) * pplPoints[1][3]) +
              (((pplPoints[1][2] * pplPoints[0][0]) -
                (pplPoints[0][2] * pplPoints[1][0])) * pplPoints[2][3])));
    GrStringDraw(thisContext, pcBuffer, -1, 0, 100, 0);

    int M2 =  ((((pplPoints[2][2] * pplPoints[1][0]) -
                (pplPoints[1][2] * pplPoints[2][0])) * pplPoints[0][3]) +
              (((pplPoints[0][2] * pplPoints[2][0]) -
                (pplPoints[2][2] * pplPoints[0][0])) * pplPoints[1][3]) +
              (((pplPoints[1][2] * pplPoints[0][0]) -
                (pplPoints[0][2] * pplPoints[1][0])) * pplPoints[2][3]));
                g_sParameters.CalibrateNum[2] = M2;

    usprintf(pcBuffer, "M3 = %d",
             (((pplPoints[0][1] - pplPoints[2][1]) *
               (pplPoints[1][3] - pplPoints[2][3])) -
              ((pplPoints[1][1] - pplPoints[2][1]) *
               (pplPoints[0][3] - pplPoints[2][3]))));
    GrStringDraw(thisContext, pcBuffer, -1, 0, 120, 0);

    int M3 =  (((pplPoints[0][1] - pplPoints[2][1]) *
               (pplPoints[1][3] - pplPoints[2][3])) -
              ((pplPoints[1][1] - pplPoints[2][1]) *
               (pplPoints[0][3] - pplPoints[2][3])));
               g_sParameters.CalibrateNum[3] = M3;

    usprintf(pcBuffer, "M4 = %d",
             (((pplPoints[0][2] - pplPoints[2][2]) *
               (pplPoints[1][1] - pplPoints[2][1])) -
              ((pplPoints[0][1] - pplPoints[2][1]) *
               (pplPoints[1][2] - pplPoints[2][2]))));
    GrStringDraw(thisContext, pcBuffer, -1, 0, 140, 0);

    int M4 =  (((pplPoints[0][2] - pplPoints[2][2]) *
               (pplPoints[1][1] - pplPoints[2][1])) -
              ((pplPoints[0][1] - pplPoints[2][1]) *
               (pplPoints[1][2] - pplPoints[2][2])));
               g_sParameters.CalibrateNum[4] = M4;

    usprintf(pcBuffer, "M5 = %d",
             ((((pplPoints[2][2] * pplPoints[1][1]) -
                (pplPoints[1][2] * pplPoints[2][1])) * pplPoints[0][3]) +
              (((pplPoints[0][2] * pplPoints[2][1]) -
                (pplPoints[2][2] * pplPoints[0][1])) * pplPoints[1][3]) +
              (((pplPoints[1][2] * pplPoints[0][1]) -
                (pplPoints[0][2] * pplPoints[1][1])) * pplPoints[2][3])));
    GrStringDraw(thisContext, pcBuffer, -1, 0, 160, 0);

    int M5 = ((((pplPoints[2][2] * pplPoints[1][1]) -
                (pplPoints[1][2] * pplPoints[2][1])) * pplPoints[0][3]) +
              (((pplPoints[0][2] * pplPoints[2][1]) -
                (pplPoints[2][2] * pplPoints[0][1])) * pplPoints[1][3]) +
              (((pplPoints[1][2] * pplPoints[0][1]) -
                (pplPoints[0][2] * pplPoints[1][1])) * pplPoints[2][3]));
                g_sParameters.CalibrateNum[5] = M5;

    usprintf(pcBuffer, "M6 = %d",
             (((pplPoints[0][2] - pplPoints[2][2]) *
               (pplPoints[1][3] - pplPoints[2][3])) -
              ((pplPoints[1][2] - pplPoints[2][2]) *
               (pplPoints[0][3] - pplPoints[2][3]))));
    GrStringDraw(thisContext, pcBuffer, -1, 0, 180, 0);

    int M6 =  (((pplPoints[0][2] - pplPoints[2][2]) *
               (pplPoints[1][3] - pplPoints[2][3])) -
              ((pplPoints[1][2] - pplPoints[2][2]) *
               (pplPoints[0][3] - pplPoints[2][3])));
               g_sParameters.CalibrateNum[6] = M6;
    TouchScreenSetParam(M0, M1 , M2 , M3 , M4 , M5 , M6);
    g_sParameters.tInitstatus = flag ;
    ParamSave();


    GrFlush(thisContext);
    WidgetMessageQueueProcess();
    char *str = "Default Seeting";
    PushButtonTextSet(&TextPushButton6 , str);
    hmi_GotoFrameByName("Frame1");
}
