#include "hmiworks.h"
#include "params.h"

//*****************************************************************************
//
// The default parameters for the motor controller.  These will be used if
// there is not a parameter block stored in flash, or if the button is pressed
// when the motor controller is powered on.
//
//*****************************************************************************
static const tParameters g_sParametersDefault =
{
    //
    // The sequence number (ucSequenceNum); this value is not important for
    // the copy in SRAM.
    //
    0,

    //
    // The CRC (ucCRC); this value is not important for the copy in SRAM.
    //
    0,

    //
    // The parameter block version number (ucVersion).
    //
    1,

 
    //{0,0,0,0}
};

//*****************************************************************************
//
// The current parameters for the motor controller.
//
//*****************************************************************************
tParameters g_sParameters;

//*****************************************************************************
//
// This function will restore the default values to the motor controller
// parameters.
//
//*****************************************************************************
void
ParamLoadDefault(void)
{
    //
    // Copy the default parameter block to the active parameter block.
    //
    g_sParameters = g_sParametersDefault;
}

//*****************************************************************************
//
// This function reads the saved motor controller parameters from flash, if
// available.
//
//*****************************************************************************
void
ParamLoad(void)
{
    unsigned char *pucBuffer;

    //
    // Get a pointer to the latest parameter block in flash.
    //
    pucBuffer = FlashPBGet();

    //
    // See if a parameter block was found in flash.
    //
    if(pucBuffer)
    {
        //
        // A parameter block was found so copy the contents to the current
        // parameter block.
        //
        g_sParameters = *(tParameters *)pucBuffer;
    }
}

//*****************************************************************************
//
// This function saves the motor controller parameters to flash, preserving
// them across any subsequent power cycles of the controller.
//
//*****************************************************************************
void
ParamSave(void)
{
    //
    // Save the current parameter block to flash.
    //
    FlashPBSave((unsigned char *)&g_sParameters);
}

//*****************************************************************************
//
// This function initializes the parameter block.  If there is a parameter
// block stored in flash, then those values will be used.  Otherwise, the
// default parameter values will be used.
//
//*****************************************************************************
void
ParamInit(void)
{
    //
    // Initialize the flash parameter block driver.
    //
    FlashPBInit(FLASH_PB_START, FLASH_PB_END, FLASH_PB_SIZE);

    //
    // First, load the parameter block with the default values.
    //
    ParamLoadDefault();

    //
    // Then, if available, load the latest non-volatile set of values.
    //
    ParamLoad();
}
