#include "hmiworks.h"

int _CurrentFrame = 0;

char *g_FrameNames[] = 
{
  "Frame1",
  "Frame2",
  "Frame3",
  "Frame4",
  "Frame5",
};

const int g_FrameCount = (sizeof(g_FrameNames)/sizeof(char *));


HANDLE UART;
HANDLE PM_2133_1;

void CheckModbus()
{

}
int g_TimerTicksCount;
void hmi_TimerTrigger()
{
  g_TimerTicksCount++;
  if (table_init_flag && (g_TimerTicksCount%(100/10)) == 0) AddQueueMessage(0);
  
  if ((g_TimerTicksCount%50) == 0) CheckModbus();
  
switch(_CurrentFrame) {
 case 1: {
break;
 }
 case 2: {
break;
 }
 case 3: {
break;
 }
 case 4: {
break;
 }
 case 5: {
break;
 }
}
}


void FreeCurrentFrame()
{
     switch (_CurrentFrame)
     {
	case 1: FreeWidget1(); break;
	case 2: FreeWidget2(); break;
	case 3: FreeWidget3(); break;
	case 4: FreeWidget4(); break;
	case 5: FreeWidget5(); break;
     }
}


void hmi_GotoFrame(int nFrame)
{
    switch(nFrame)
    {
	case 1: _frame1(); break;
	case 2: _frame2(); break;
	case 3: _frame3(); break;
	case 4: _frame4(); break;
	case 5: _frame5(); break;
    }

}


int hmi_IndexOfFrame(const char *frame_name)
{
    int i;
    for (i=0; i<g_FrameCount; i++)
       if (strcmp(frame_name, g_FrameNames[i]) == 0) return i+1;
    return 0;
}


void hmi_GotoFrameByName(const char *frame_name)
{
    hmi_GotoFrame(hmi_IndexOfFrame(frame_name));
}

BYTE ladder_main(BYTE);
static BYTE r_out(BYTE);

long default_timer_proc(tWidget *pWidget, unsigned long ulMessage,
                     unsigned long ulParam1, unsigned long ulParam2)

{
  ladder_main(1);
  r_out(1);
  return 1;
}

static BYTE r_out(BYTE en)
{
  default_output(1);



static int polling_module;
switch(polling_module++%1) {
case 0:
BEGIN_FUNCTION_BLOCK();

static int uCount = 0;
uCount++;
if (uCount%3) break;

unsigned char str[8] = {0x01, 0x04, 0x11, 0x00, 0x00, 0x48, 0xF5, 0x00};

//str[0] = slave address
//str[1] = function 
//str[2,3] = start address
//str[4,5] = length
//str[6,7] = checksum


char recv[149];
char a[4];

float sng;
float Volt[4];
float Current[4];
float Power[4];
float PF[4];
int temp;


BOOL flag = uart_BinSendCmd(PM_2133_1, str, sizeof(str), recv, 149);
SysCtlDelay(30000);

WORD ret_crc = CRC16(recv, 147);

if (flag)
if (memcmp(recv, str, 2) == 0)
if (ret_crc == (*(unsigned short *)(recv+147))) 
{
	for(int i = 0 ; i<4 ; i++)
	{
        a[3] = recv[3 + i * 36 + 2];
        a[2] = recv[3 + i * 36 + 3];
        a[1] = recv[3 + i * 36 + 0];
        a[0] = recv[3 + i * 36 + 1];
		memcpy(&sng, a, 4);
        Volt[i] = sng;
        //-------------------------------
         
        a[3] = recv[3 + i * 36 + 4 + 2];
        a[2] = recv[3 + i * 36 + 4 + 3];
        a[1] = recv[3 + i * 36 + 4 + 0];
        a[0] = recv[3 + i * 36 + 4 + 1];
       
        memcpy(&sng, a, 4);
        Current[i] = sng*1000;
        //--------------------------
        a[3] = recv[3 + i * 36 + 8 + 2];
        a[2] = recv[3 + i * 36 + 8 + 3];
        a[1] = recv[3 + i * 36 + 8 + 0];
        a[0] = recv[3 + i * 36 + 8 + 1];
        
        memcpy(&sng, a, 4);
        Power[i] = sng*1000;
        //----------------
        
        a[3] = recv[3 + i * 36 + 20 + 2];
        a[2] = recv[3 + i * 36 + 20 + 3];
        a[1] = recv[3 + i * 36 + 20 + 0];
        a[0] = recv[3 + i * 36 + 20 + 1];
        memcpy(&sng, a, 4);
        PF[i] = sng*1000;
	}
	
	VAR_SET(PM_2133_1_AI0, Volt[0]);
	VAR_SET(PM_2133_1_AI1, Current[0]);
	VAR_SET(PM_2133_1_AI2, Power[0]);
	VAR_SET(PM_2133_1_AI3, PF[0]);
	
	
	VAR_SET(PM_2133_1_AI4, Volt[1]);
	VAR_SET(PM_2133_1_AI5, Current[1]);
	VAR_SET(PM_2133_1_AI6, Power[1]);
	VAR_SET(PM_2133_1_AI7, PF[1]);

    VAR_SET(PM_2133_1_AI8, Volt[2]);
	VAR_SET(PM_2133_1_AI9, Current[2]);
	VAR_SET(PM_2133_1_AI10, Power[2]);
	VAR_SET(PM_2133_1_AI11, PF[2]);

	VAR_SET(PM_2133_1_AI12, Volt[3]);
	VAR_SET(PM_2133_1_AI13, Current[3]);
	VAR_SET(PM_2133_1_AI14, Power[3]);
	VAR_SET(PM_2133_1_AI15, PF[3]);
	
}
END_FUNCTION_BLOCK();

break;

} //end switch

  default_input(1);

return 0;
}

void _frame0()
{
  tContext sContext;
  
  hmi_Beep();
  UART = uart_Open("COM0,19200,N,8,1");
  PM_2133_1 = UART;
  hmi_Beep();
  
  
  RegisterNullWidgetMsgProc(default_timer_proc);
  
  GrContextInit(&sContext, HMI_DISPLAY_DRIVER_PTR);
  hmi_GotoFrame(1);
  GrFlush(&sContext);
}
