#include "hmiworks.h"

int _CurrentFrame = 0;

char *g_FrameNames[] = 
{
  "Frame1",
};

const int g_FrameCount = (sizeof(g_FrameNames)/sizeof(char *));


HANDLE UART;
HANDLE I_7018_2;

void CheckModbus()
{

}
int g_TimerTicksCount;
void hmi_TimerTrigger()
{
  g_TimerTicksCount++;
  if (table_init_flag && (g_TimerTicksCount%(100/10)) == 0) AddQueueMessage(0);
  
  if ((g_TimerTicksCount%50) == 0) CheckModbus();
  
switch(_CurrentFrame) {
 case 1: {
break;
 }
}
}


void FreeCurrentFrame()
{
     switch (_CurrentFrame)
     {
	case 1: FreeWidget1(); break;
     }
}


void hmi_GotoFrame(int nFrame)
{
    switch(nFrame)
    {
	case 1: _frame1(); break;
    }

}


int hmi_IndexOfFrame(const char *frame_name)
{
    int i;
    for (i=0; i<g_FrameCount; i++)
       if (strcmp(frame_name, g_FrameNames[i]) == 0) return i+1;
    return 0;
}


void hmi_GotoFrameByName(const char *frame_name)
{
    hmi_GotoFrame(hmi_IndexOfFrame(frame_name));
}

BYTE ladder_main(BYTE);
static BYTE r_out(BYTE);

long default_timer_proc(tWidget *pWidget, unsigned long ulMessage,
                     unsigned long ulParam1, unsigned long ulParam2)

{
  ladder_main(1);
  r_out(1);
  return 1;
}

static BYTE r_out(BYTE en)
{
  default_output(1);



static int polling_module;
switch(polling_module++%1) {
case 0:
BEGIN_FUNCTION_BLOCK();

float v_ai[8];

if (VAR_VALUE(I_7018_2_R_ACTION)) 
if(dcon_ReadAIAll(I_7018_2, 2, v_ai)) {
	VAR_SET(I_7018_2_AI0, v_ai[0]);
	VAR_SET(I_7018_2_AI1, v_ai[1]);
	VAR_SET(I_7018_2_AI2, v_ai[2]);
	VAR_SET(I_7018_2_AI3, v_ai[3]);
	VAR_SET(I_7018_2_AI4, v_ai[4]);
	VAR_SET(I_7018_2_AI5, v_ai[5]);
	VAR_SET(I_7018_2_AI6, v_ai[6]);
	VAR_SET(I_7018_2_AI7, v_ai[7]);
}

END_FUNCTION_BLOCK();

break;

} //end switch

  default_input(1);

return 0;
}

void _frame0()
{
  tContext sContext;
  
  hmi_Beep();
  UART = uart_Open("COM0,115200,N,8,1");
  I_7018_2 = UART;
  hmi_Beep();
  
  
  RegisterNullWidgetMsgProc(default_timer_proc);
  
  GrContextInit(&sContext, HMI_DISPLAY_DRIVER_PTR);
  hmi_GotoFrame(1);
  GrFlush(&sContext);
}
